/*
 * Decompiled with CFR 0.152.
 */
package io.confluent.kafka.schemaregistry.rest;

import io.confluent.kafka.schemaregistry.exceptions.SchemaRegistryException;
import io.confluent.kafka.schemaregistry.rest.SchemaRegistryConfig;
import io.confluent.kafka.schemaregistry.rest.extensions.SchemaRegistryResourceExtension;
import io.confluent.kafka.schemaregistry.rest.resources.CompatibilityResource;
import io.confluent.kafka.schemaregistry.rest.resources.ConfigResource;
import io.confluent.kafka.schemaregistry.rest.resources.RootResource;
import io.confluent.kafka.schemaregistry.rest.resources.SchemasResource;
import io.confluent.kafka.schemaregistry.rest.resources.SubjectVersionsResource;
import io.confluent.kafka.schemaregistry.rest.resources.SubjectsResource;
import io.confluent.kafka.schemaregistry.storage.KafkaSchemaRegistry;
import io.confluent.kafka.schemaregistry.storage.serialization.SchemaRegistrySerializer;
import io.confluent.rest.Application;
import io.confluent.rest.RestConfig;
import io.confluent.rest.RestConfigException;
import java.io.IOException;
import java.util.List;
import java.util.Properties;
import javax.ws.rs.core.Configurable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SchemaRegistryRestApplication
extends Application<SchemaRegistryConfig> {
    private static final Logger log = LoggerFactory.getLogger(SchemaRegistryRestApplication.class);
    private KafkaSchemaRegistry schemaRegistry = null;
    private List<SchemaRegistryResourceExtension> schemaRegistryResourceExtensions = null;

    public SchemaRegistryRestApplication(Properties props) throws RestConfigException {
        this(new SchemaRegistryConfig(props));
    }

    public SchemaRegistryRestApplication(SchemaRegistryConfig config) {
        super((RestConfig)config);
    }

    public void setupResources(Configurable<?> config, SchemaRegistryConfig schemaRegistryConfig) {
        try {
            this.schemaRegistry = new KafkaSchemaRegistry(schemaRegistryConfig, new SchemaRegistrySerializer());
            this.schemaRegistry.init();
        }
        catch (SchemaRegistryException e) {
            log.error("Error starting the schema registry", (Throwable)e);
            this.onShutdown();
            System.exit(1);
        }
        this.schemaRegistryResourceExtensions = schemaRegistryConfig.getConfiguredInstances(schemaRegistryConfig.definedResourceExtensionConfigName(), SchemaRegistryResourceExtension.class);
        config.register(RootResource.class);
        config.register((Object)new ConfigResource(this.schemaRegistry));
        config.register((Object)new SubjectsResource(this.schemaRegistry));
        config.register((Object)new SchemasResource(this.schemaRegistry));
        config.register((Object)new SubjectVersionsResource(this.schemaRegistry));
        config.register((Object)new CompatibilityResource(this.schemaRegistry));
        if (this.schemaRegistryResourceExtensions != null) {
            try {
                for (SchemaRegistryResourceExtension schemaRegistryResourceExtension : this.schemaRegistryResourceExtensions) {
                    schemaRegistryResourceExtension.register(config, schemaRegistryConfig, this.schemaRegistry);
                }
            }
            catch (SchemaRegistryException e) {
                log.error("Error starting the schema registry", (Throwable)e);
                System.exit(1);
            }
        }
    }

    public void onShutdown() {
        if (this.schemaRegistry != null) {
            this.schemaRegistry.close();
        }
        if (this.schemaRegistryResourceExtensions != null) {
            for (SchemaRegistryResourceExtension schemaRegistryResourceExtension : this.schemaRegistryResourceExtensions) {
                try {
                    schemaRegistryResourceExtension.close();
                }
                catch (IOException e) {
                    log.error("Error closing the extension resource", (Throwable)e);
                }
            }
        }
    }

    public KafkaSchemaRegistry schemaRegistry() {
        return this.schemaRegistry;
    }
}

