/*
 * Decompiled with CFR 0.152.
 */
package io.confluent.kafka.schemaregistry.storage;

import io.confluent.kafka.schemaregistry.avro.AvroCompatibilityLevel;
import io.confluent.kafka.schemaregistry.client.rest.entities.Schema;
import io.confluent.kafka.schemaregistry.storage.ConfigKey;
import io.confluent.kafka.schemaregistry.storage.ConfigValue;
import io.confluent.kafka.schemaregistry.storage.LookupCache;
import io.confluent.kafka.schemaregistry.storage.MD5;
import io.confluent.kafka.schemaregistry.storage.Mode;
import io.confluent.kafka.schemaregistry.storage.ModeKey;
import io.confluent.kafka.schemaregistry.storage.ModeValue;
import io.confluent.kafka.schemaregistry.storage.SchemaIdAndSubjects;
import io.confluent.kafka.schemaregistry.storage.SchemaKey;
import io.confluent.kafka.schemaregistry.storage.SchemaValue;
import io.confluent.kafka.schemaregistry.storage.exceptions.StoreException;
import io.confluent.kafka.schemaregistry.storage.exceptions.StoreInitializationException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.SortedMap;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentNavigableMap;
import java.util.concurrent.ConcurrentSkipListMap;
import java.util.function.Predicate;

public class InMemoryCache<K, V>
implements LookupCache<K, V> {
    protected final ConcurrentNavigableMap<K, V> store;
    private final Map<Integer, SchemaKey> guidToSchemaKey;
    private final Map<MD5, SchemaIdAndSubjects> schemaHashToGuid;
    private final Map<Integer, List<SchemaKey>> guidToDeletedSchemaKeys;

    public InMemoryCache() {
        this(new ConcurrentSkipListMap());
    }

    public InMemoryCache(ConcurrentNavigableMap<K, V> store) {
        this.store = store;
        this.guidToSchemaKey = new ConcurrentHashMap<Integer, SchemaKey>();
        this.schemaHashToGuid = new ConcurrentHashMap<MD5, SchemaIdAndSubjects>();
        this.guidToDeletedSchemaKeys = new ConcurrentHashMap<Integer, List<SchemaKey>>();
    }

    @Override
    public void init() throws StoreInitializationException {
    }

    @Override
    public V get(K key) {
        return this.store.get(key);
    }

    @Override
    public void put(K key, V value) throws StoreException {
        this.store.put(key, value);
    }

    @Override
    public Iterator<V> getAll(K key1, K key2) {
        SortedMap<K, V> subMap = key1 == null && key2 == null ? this.store : this.store.subMap((Object)key1, (Object)key2);
        return subMap.values().iterator();
    }

    @Override
    public void putAll(Map<K, V> entries) {
        this.store.putAll(entries);
    }

    @Override
    public void delete(K key) throws StoreException {
        this.store.remove(key);
    }

    @Override
    public Iterator<K> getAllKeys() throws StoreException {
        return this.store.keySet().iterator();
    }

    @Override
    public void close() {
        this.store.clear();
    }

    @Override
    public SchemaIdAndSubjects schemaIdAndSubjects(Schema schema) {
        MD5 md5 = MD5.ofString(schema.getSchema());
        return this.schemaHashToGuid.get(md5);
    }

    @Override
    public boolean containsSchema(Schema schema) {
        MD5 md5 = MD5.ofString(schema.getSchema());
        return this.schemaHashToGuid.containsKey(md5);
    }

    @Override
    public SchemaKey schemaKeyById(Integer id) {
        return this.guidToSchemaKey.get(id);
    }

    @Override
    public void schemaDeleted(SchemaKey schemaKey, SchemaValue schemaValue) {
        this.guidToSchemaKey.put(schemaValue.getId(), schemaKey);
        this.addToSchemaHashToGuid(schemaKey, schemaValue);
        this.guidToDeletedSchemaKeys.computeIfAbsent(schemaValue.getId(), k -> new ArrayList()).add(schemaKey);
    }

    @Override
    public void schemaTombstoned(SchemaKey schemaKey) {
        this.schemaHashToGuid.values().forEach(v -> v.removeIf(k -> k.equals(schemaKey)));
        this.guidToDeletedSchemaKeys.values().forEach(v -> v.removeIf(k -> k.equals(schemaKey)));
    }

    @Override
    public void schemaRegistered(SchemaKey schemaKey, SchemaValue schemaValue) {
        this.guidToSchemaKey.put(schemaValue.getId(), schemaKey);
        this.addToSchemaHashToGuid(schemaKey, schemaValue);
    }

    private void addToSchemaHashToGuid(SchemaKey schemaKey, SchemaValue schemaValue) {
        MD5 md5 = MD5.ofString(schemaValue.getSchema());
        SchemaIdAndSubjects schemaIdAndSubjects = this.schemaHashToGuid.get(md5);
        if (schemaIdAndSubjects == null) {
            schemaIdAndSubjects = new SchemaIdAndSubjects(schemaValue.getId());
        }
        schemaIdAndSubjects.addSubjectAndVersion(schemaKey.getSubject(), schemaKey.getVersion());
        this.schemaHashToGuid.put(md5, schemaIdAndSubjects);
    }

    @Override
    public List<SchemaKey> deletedSchemaKeys(SchemaValue schemaValue) {
        return this.guidToDeletedSchemaKeys.getOrDefault(schemaValue.getId(), Collections.emptyList());
    }

    @Override
    public AvroCompatibilityLevel compatibilityLevel(String subject, boolean returnTopLevelIfNotFound, AvroCompatibilityLevel defaultForTopLevel) {
        ConfigKey subjectConfigKey = new ConfigKey(subject);
        ConfigValue config = (ConfigValue)this.get(subjectConfigKey);
        if (config == null && subject == null) {
            return defaultForTopLevel;
        }
        if (config != null) {
            return config.getCompatibilityLevel();
        }
        if (returnTopLevelIfNotFound) {
            config = (ConfigValue)this.get(new ConfigKey(null));
            return config != null ? config.getCompatibilityLevel() : defaultForTopLevel;
        }
        return null;
    }

    @Override
    public Mode mode(String subject, boolean returnTopLevelIfNotFound, Mode defaultForTopLevel) {
        ModeKey modeKey = new ModeKey(subject);
        ModeValue modeValue = (ModeValue)this.get(modeKey);
        if (modeValue == null && subject == null) {
            return defaultForTopLevel;
        }
        if (modeValue != null) {
            return modeValue.getMode();
        }
        if (returnTopLevelIfNotFound) {
            modeValue = (ModeValue)this.get(new ModeKey(null));
            return modeValue != null ? modeValue.getMode() : defaultForTopLevel;
        }
        return null;
    }

    @Override
    public boolean hasSubjects(String subject) {
        return this.hasSubjects(this.matchingPredicate(subject));
    }

    public boolean hasSubjects(Predicate<String> match) {
        return this.store.entrySet().stream().anyMatch(e -> {
            Object k = e.getKey();
            Object v = e.getValue();
            if (k instanceof SchemaKey) {
                SchemaKey key = (SchemaKey)k;
                SchemaValue value = (SchemaValue)v;
                if (value != null && !value.isDeleted()) {
                    return match.test(key.getSubject());
                }
            }
            return false;
        });
    }

    @Override
    public void clearSubjects(String subject) {
        this.clearSubjects(this.matchingPredicate(subject));
    }

    public void clearSubjects(Predicate<String> match) {
        Predicate<SchemaKey> matchDeleted = this.matchDeleted(match);
        this.replaceMatchingDeletedWithNonDeletedOrRemove(match);
        this.schemaHashToGuid.values().forEach(v -> v.removeIf(matchDeleted));
        this.schemaHashToGuid.entrySet().removeIf(e -> ((SchemaIdAndSubjects)e.getValue()).isEmpty());
        this.guidToDeletedSchemaKeys.values().forEach(v -> v.removeIf(matchDeleted));
        this.guidToDeletedSchemaKeys.entrySet().removeIf(e -> ((List)e.getValue()).isEmpty());
        this.store.entrySet().removeIf(e -> {
            if (e.getKey() instanceof SchemaKey) {
                SchemaKey key = (SchemaKey)e.getKey();
                SchemaValue value = (SchemaValue)e.getValue();
                return match.test(key.getSubject()) && value.isDeleted();
            }
            return false;
        });
    }

    private Predicate<String> matchingPredicate(String subject) {
        return s -> subject == null || subject.equals(s);
    }

    protected void replaceMatchingDeletedWithNonDeletedOrRemove(Predicate<String> match) {
        Predicate<SchemaKey> matchDeleted = this.matchDeleted(match);
        Iterator<Map.Entry<Integer, SchemaKey>> it = this.guidToSchemaKey.entrySet().iterator();
        while (it.hasNext()) {
            SchemaKey newSchemaKey;
            Map.Entry<Integer, SchemaKey> entry = it.next();
            SchemaKey schemaKey = entry.getValue();
            if (!matchDeleted.test(schemaKey)) continue;
            SchemaValue schemaValue = (SchemaValue)this.store.get(schemaKey);
            SchemaKey schemaKey2 = newSchemaKey = schemaValue != null ? this.getNonDeletedSchemaKey(schemaValue.getSchema()) : null;
            if (newSchemaKey != null) {
                entry.setValue(newSchemaKey);
                continue;
            }
            it.remove();
        }
    }

    private SchemaKey getNonDeletedSchemaKey(String schema) {
        MD5 md5 = MD5.ofString(schema);
        SchemaIdAndSubjects keys = this.schemaHashToGuid.get(md5);
        return keys == null ? null : keys.findAny(key -> {
            SchemaValue value = (SchemaValue)this.store.get(key);
            return value != null && !value.isDeleted();
        });
    }

    private Predicate<SchemaKey> matchDeleted(Predicate<String> match) {
        return key -> {
            if (match.test(key.getSubject())) {
                SchemaValue value = (SchemaValue)this.store.get(key);
                return value == null || value.isDeleted();
            }
            return false;
        };
    }
}

