/*
 * Decompiled with CFR 0.152.
 */
package io.confluent.kafka.schemaregistry.rest.resources;

import io.confluent.kafka.schemaregistry.client.rest.entities.Schema;
import io.confluent.kafka.schemaregistry.client.rest.entities.requests.CompatibilityCheckResponse;
import io.confluent.kafka.schemaregistry.client.rest.entities.requests.RegisterSchemaRequest;
import io.confluent.kafka.schemaregistry.exceptions.InvalidSchemaException;
import io.confluent.kafka.schemaregistry.exceptions.InvalidVersionException;
import io.confluent.kafka.schemaregistry.exceptions.SchemaRegistryException;
import io.confluent.kafka.schemaregistry.exceptions.SchemaRegistryStoreException;
import io.confluent.kafka.schemaregistry.rest.VersionId;
import io.confluent.kafka.schemaregistry.rest.exceptions.Errors;
import io.confluent.kafka.schemaregistry.storage.KafkaSchemaRegistry;
import io.confluent.rest.annotations.PerformanceMetric;
import io.swagger.annotations.ApiOperation;
import io.swagger.annotations.ApiParam;
import io.swagger.annotations.ApiResponse;
import io.swagger.annotations.ApiResponses;
import javax.validation.constraints.NotNull;
import javax.ws.rs.Consumes;
import javax.ws.rs.HeaderParam;
import javax.ws.rs.POST;
import javax.ws.rs.Path;
import javax.ws.rs.PathParam;
import javax.ws.rs.Produces;
import javax.ws.rs.container.AsyncResponse;
import javax.ws.rs.container.Suspended;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Path(value="/compatibility")
@Produces(value={"application/vnd.schemaregistry.v1+json", "application/vnd.schemaregistry+json; qs=0.9", "application/json; qs=0.5"})
@Consumes(value={"application/vnd.schemaregistry.v1+json", "application/vnd.schemaregistry+json", "application/json", "application/octet-stream"})
public class CompatibilityResource {
    private static final Logger log = LoggerFactory.getLogger(CompatibilityResource.class);
    private final KafkaSchemaRegistry schemaRegistry;

    public CompatibilityResource(KafkaSchemaRegistry schemaRegistry) {
        this.schemaRegistry = schemaRegistry;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @POST
    @Path(value="/subjects/{subject}/versions/{version}")
    @ApiOperation(value="Test input schema against a particular version of a subject's schema for compatibility.", notes="the compatibility level applied for the check is the configured compatibility level for the subject (http:get:: /config/(string: subject)). If this subject's compatibility level was never changed, then the global compatibility level applies (http:get:: /config).", response=CompatibilityCheckResponse.class)
    @ApiResponses(value={@ApiResponse(code=404, message="Error code 40401 -- Subject not found\nError code 40402 -- Version not found"), @ApiResponse(code=422, message="Error code 42201 -- Invalid schema or schema type\nError code 42202 -- Invalid version"), @ApiResponse(code=500, message="Error code 50001 -- Error in the backend data store")})
    @PerformanceMetric(value="compatibility.subjects.versions.verify")
    public void testCompatibilityBySubjectName(@Suspended AsyncResponse asyncResponse, @HeaderParam(value="Content-Type") String contentType, @HeaderParam(value="Accept") String accept, @ApiParam(value="Subject of the schema version against which compatibility is to be tested", required=true) @PathParam(value="subject") String subject, @ApiParam(value="Version of the subject's schema against which compatibility is to be tested. Valid values for versionId are between [1,2^31-1] or the string \"latest\".\"latest\" checks compatibility of the input schema with the last registered schema under the specified subject", required=true) @PathParam(value="version") String version, @ApiParam(value="Schema", required=true) @NotNull RegisterSchemaRequest request) {
        log.info("Testing schema subject {} compatibility between existing version {} and specified version {}, id {}, type {}", new Object[]{subject, version, request.getVersion(), request.getId(), request.getSchemaType()});
        boolean isCompatible = false;
        CompatibilityCheckResponse compatibilityCheckResponse = new CompatibilityCheckResponse();
        String errorMessage = "Error while retrieving list of all subjects";
        Schema schemaForSpecifiedVersion = null;
        VersionId versionId = CompatibilityResource.parseVersionId(version);
        try {
            schemaForSpecifiedVersion = this.schemaRegistry.get(subject, versionId.getVersionId(), false);
        }
        catch (InvalidVersionException e) {
            throw Errors.invalidVersionException(e.getMessage());
        }
        catch (SchemaRegistryException e) {
            throw Errors.storeException("Error while retrieving schema for subject " + subject + " and version " + versionId.getVersionId(), e);
        }
        this.registerWithError(subject, errorMessage);
        if (schemaForSpecifiedVersion == null) {
            if (!versionId.isLatest()) throw Errors.versionNotFoundException(versionId.getVersionId());
            isCompatible = true;
            compatibilityCheckResponse.setIsCompatible(isCompatible);
            asyncResponse.resume((Object)compatibilityCheckResponse);
            return;
        }
        try {
            isCompatible = this.schemaRegistry.isCompatible(subject, new Schema(subject, request.getVersion(), request.getId(), request.getSchemaType(), request.getReferences(), request.getSchema()), schemaForSpecifiedVersion);
        }
        catch (InvalidSchemaException e) {
            throw Errors.invalidSchemaException("Invalid input schema " + request.getSchema(), e);
        }
        catch (SchemaRegistryStoreException e) {
            throw Errors.storeException("Error while getting compatibility level for subject " + subject, e);
        }
        catch (SchemaRegistryException e) {
            throw Errors.schemaRegistryException("Error while getting compatibility level for subject " + subject, e);
        }
        compatibilityCheckResponse.setIsCompatible(isCompatible);
        asyncResponse.resume((Object)compatibilityCheckResponse);
    }

    private static VersionId parseVersionId(String version) {
        VersionId versionId;
        try {
            versionId = new VersionId(version);
        }
        catch (InvalidVersionException e) {
            throw Errors.invalidVersionException(e.getMessage());
        }
        return versionId;
    }

    private void registerWithError(String subject, String errorMessage) {
        try {
            if (!this.schemaRegistry.hasSubjects(subject)) {
                throw Errors.subjectNotFoundException(subject);
            }
        }
        catch (SchemaRegistryStoreException e) {
            throw Errors.storeException(errorMessage, e);
        }
        catch (SchemaRegistryException e) {
            throw Errors.schemaRegistryException(errorMessage, e);
        }
    }
}

