/*
 * Decompiled with CFR 0.152.
 */
package io.confluent.kafka.schemaregistry.storage;

import io.confluent.kafka.schemaregistry.CompatibilityLevel;
import io.confluent.kafka.schemaregistry.client.rest.entities.Schema;
import io.confluent.kafka.schemaregistry.storage.ConfigKey;
import io.confluent.kafka.schemaregistry.storage.ConfigValue;
import io.confluent.kafka.schemaregistry.storage.LookupCache;
import io.confluent.kafka.schemaregistry.storage.MD5;
import io.confluent.kafka.schemaregistry.storage.Mode;
import io.confluent.kafka.schemaregistry.storage.ModeKey;
import io.confluent.kafka.schemaregistry.storage.ModeValue;
import io.confluent.kafka.schemaregistry.storage.SchemaIdAndSubjects;
import io.confluent.kafka.schemaregistry.storage.SchemaKey;
import io.confluent.kafka.schemaregistry.storage.SchemaReference;
import io.confluent.kafka.schemaregistry.storage.SchemaValue;
import io.confluent.kafka.schemaregistry.storage.exceptions.StoreException;
import io.confluent.kafka.schemaregistry.storage.exceptions.StoreInitializationException;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.SortedMap;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentNavigableMap;
import java.util.concurrent.ConcurrentSkipListMap;
import java.util.function.BiPredicate;
import java.util.function.Predicate;
import java.util.stream.Collectors;

public class InMemoryCache<K, V>
implements LookupCache<K, V> {
    protected final ConcurrentNavigableMap<K, V> store;
    private final Map<Integer, Map<String, Integer>> guidToSubjectVersions;
    private final Map<MD5, Integer> hashToGuid;
    private final Map<SchemaKey, Set<Integer>> referencedBy;

    public InMemoryCache() {
        this(new ConcurrentSkipListMap());
    }

    public InMemoryCache(ConcurrentNavigableMap<K, V> store) {
        this.store = store;
        this.guidToSubjectVersions = new ConcurrentHashMap<Integer, Map<String, Integer>>();
        this.hashToGuid = new ConcurrentHashMap<MD5, Integer>();
        this.referencedBy = new ConcurrentHashMap<SchemaKey, Set<Integer>>();
    }

    @Override
    public void init() throws StoreInitializationException {
    }

    @Override
    public V get(K key) {
        return this.store.get(key);
    }

    @Override
    public V put(K key, V value) throws StoreException {
        return this.store.put(key, value);
    }

    @Override
    public Iterator<V> getAll(K key1, K key2) {
        SortedMap<K, V> subMap = key1 == null && key2 == null ? this.store : this.store.subMap((Object)key1, (Object)key2);
        return subMap.values().iterator();
    }

    @Override
    public void putAll(Map<K, V> entries) {
        this.store.putAll(entries);
    }

    @Override
    public V delete(K key) throws StoreException {
        return this.store.remove(key);
    }

    @Override
    public Iterator<K> getAllKeys() throws StoreException {
        return this.store.keySet().iterator();
    }

    @Override
    public void close() {
        this.store.clear();
    }

    @Override
    public SchemaIdAndSubjects schemaIdAndSubjects(Schema schema) {
        List refs = schema.getReferences();
        MD5 md5 = MD5.ofString(schema.getSchema(), refs == null ? null : refs.stream().map(ref -> new SchemaReference(ref.getName(), ref.getSubject(), ref.getVersion())).collect(Collectors.toList()));
        Integer id = this.hashToGuid.get(md5);
        if (id == null) {
            return null;
        }
        Map<String, Integer> subjectVersions = this.guidToSubjectVersions.get(id);
        if (subjectVersions == null || subjectVersions.isEmpty()) {
            return null;
        }
        return new SchemaIdAndSubjects(id, subjectVersions);
    }

    @Override
    public boolean containsSchema(Schema schema) {
        return this.schemaIdAndSubjects(schema) != null;
    }

    @Override
    public Set<Integer> referencesSchema(SchemaKey schema) {
        return this.referencedBy.getOrDefault(schema, new HashSet());
    }

    @Override
    public SchemaKey schemaKeyById(Integer id) {
        Map<String, Integer> subjectVersions = this.guidToSubjectVersions.get(id);
        if (subjectVersions == null || subjectVersions.isEmpty()) {
            return null;
        }
        Map.Entry<String, Integer> entry = subjectVersions.entrySet().iterator().next();
        return new SchemaKey(entry.getKey(), entry.getValue());
    }

    @Override
    public void schemaDeleted(SchemaKey schemaKey, SchemaValue schemaValue) {
        Map subjectVersions = this.guidToSubjectVersions.computeIfAbsent(schemaValue.getId(), k -> new HashMap());
        subjectVersions.put(schemaKey.getSubject(), schemaKey.getVersion());
        this.addToSchemaHashToGuid(schemaKey, schemaValue);
        for (SchemaReference ref : schemaValue.getReferences()) {
            SchemaKey refKey = new SchemaKey(ref.getSubject(), ref.getVersion());
            Set<Integer> refBy = this.referencedBy.get(refKey);
            if (refBy == null) continue;
            refBy.remove(schemaValue.getId());
            if (!refBy.isEmpty()) continue;
            this.referencedBy.remove(refKey);
        }
    }

    @Override
    public void schemaTombstoned(SchemaKey schemaKey, SchemaValue schemaValue) {
        if (schemaValue == null) {
            return;
        }
        Map<String, Integer> subjectVersions = this.guidToSubjectVersions.get(schemaValue.getId());
        if (subjectVersions == null || subjectVersions.isEmpty()) {
            return;
        }
        subjectVersions.computeIfPresent(schemaKey.getSubject(), (k, v) -> schemaKey.getVersion() == v.intValue() ? null : v);
        if (subjectVersions.isEmpty()) {
            this.guidToSubjectVersions.remove(schemaValue.getId());
        }
    }

    @Override
    public void schemaRegistered(SchemaKey schemaKey, SchemaValue schemaValue) {
        Map subjectVersions = this.guidToSubjectVersions.computeIfAbsent(schemaValue.getId(), k -> new HashMap());
        subjectVersions.put(schemaKey.getSubject(), schemaKey.getVersion());
        this.addToSchemaHashToGuid(schemaKey, schemaValue);
        for (SchemaReference ref : schemaValue.getReferences()) {
            SchemaKey refKey = new SchemaKey(ref.getSubject(), ref.getVersion());
            Set refBy = this.referencedBy.computeIfAbsent(refKey, k -> new HashSet());
            refBy.add(schemaValue.getId());
        }
    }

    private void addToSchemaHashToGuid(SchemaKey schemaKey, SchemaValue schemaValue) {
        MD5 md5 = MD5.ofString(schemaValue.getSchema(), schemaValue.getReferences());
        this.hashToGuid.put(md5, schemaValue.getId());
    }

    @Override
    public CompatibilityLevel compatibilityLevel(String subject, boolean returnTopLevelIfNotFound, CompatibilityLevel defaultForTopLevel) {
        ConfigKey subjectConfigKey = new ConfigKey(subject);
        ConfigValue config = (ConfigValue)this.get(subjectConfigKey);
        if (config == null && subject == null) {
            return defaultForTopLevel;
        }
        if (config != null) {
            return config.getCompatibilityLevel();
        }
        if (returnTopLevelIfNotFound) {
            config = (ConfigValue)this.get(new ConfigKey(null));
            return config != null ? config.getCompatibilityLevel() : defaultForTopLevel;
        }
        return null;
    }

    @Override
    public Mode mode(String subject, boolean returnTopLevelIfNotFound, Mode defaultForTopLevel) {
        ModeKey modeKey = new ModeKey(subject);
        ModeValue modeValue = (ModeValue)this.get(modeKey);
        if (modeValue == null && subject == null) {
            return defaultForTopLevel;
        }
        if (modeValue != null) {
            return modeValue.getMode();
        }
        if (returnTopLevelIfNotFound) {
            modeValue = (ModeValue)this.get(new ModeKey(null));
            return modeValue != null ? modeValue.getMode() : defaultForTopLevel;
        }
        return null;
    }

    @Override
    public boolean hasSubjects(String subject) {
        return this.hasSubjects(this.matchingPredicate(subject));
    }

    public boolean hasSubjects(Predicate<String> match) {
        return this.store.entrySet().stream().anyMatch(e -> {
            Object k = e.getKey();
            Object v = e.getValue();
            if (k instanceof SchemaKey) {
                SchemaKey key = (SchemaKey)k;
                SchemaValue value = (SchemaValue)v;
                if (value != null && !value.isDeleted()) {
                    return match.test(key.getSubject());
                }
            }
            return false;
        });
    }

    @Override
    public void clearSubjects(String subject) {
        this.clearSubjects(this.matchingPredicate(subject));
    }

    public void clearSubjects(Predicate<String> match) {
        BiPredicate<String, Integer> matchDeleted = this.matchDeleted(match);
        Iterator<Map.Entry<Integer, Map<String, Integer>>> it = this.guidToSubjectVersions.entrySet().iterator();
        while (it.hasNext()) {
            Map<String, Integer> subjectVersions = it.next().getValue();
            subjectVersions.entrySet().removeIf(e -> matchDeleted.test((String)e.getKey(), (Integer)e.getValue()));
            if (!subjectVersions.isEmpty()) continue;
            it.remove();
        }
        this.store.entrySet().removeIf(e -> {
            if (e.getKey() instanceof SchemaKey) {
                SchemaKey key = (SchemaKey)e.getKey();
                SchemaValue value = (SchemaValue)e.getValue();
                return match.test(key.getSubject()) && value.isDeleted();
            }
            return false;
        });
    }

    private Predicate<String> matchingPredicate(String subject) {
        return s -> subject == null || subject.equals(s);
    }

    private BiPredicate<String, Integer> matchDeleted(Predicate<String> match) {
        return (subject, version) -> {
            if (match.test((String)subject)) {
                SchemaValue value = (SchemaValue)this.store.get(new SchemaKey((String)subject, (int)version));
                return value == null || value.isDeleted();
            }
            return false;
        };
    }
}

