/*
 * Decompiled with CFR 0.152.
 */
package io.confluent.kafka.schemaregistry.rest.protobuf;

import com.google.protobuf.Message;
import io.confluent.kafka.schemaregistry.ClusterTestHarness;
import io.confluent.kafka.schemaregistry.client.rest.RestService;
import io.confluent.kafka.schemaregistry.client.rest.entities.Schema;
import io.confluent.kafka.schemaregistry.client.rest.entities.SchemaReference;
import io.confluent.kafka.schemaregistry.client.rest.entities.SchemaString;
import io.confluent.kafka.schemaregistry.client.rest.entities.requests.RegisterSchemaRequest;
import io.confluent.kafka.schemaregistry.client.rest.exceptions.RestClientException;
import io.confluent.kafka.schemaregistry.protobuf.ProtobufSchema;
import io.confluent.kafka.schemaregistry.protobuf.ProtobufSchemaProvider;
import io.confluent.kafka.schemaregistry.protobuf.ProtobufSchemaUtils;
import io.confluent.kafka.serializers.protobuf.test.Root;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.Random;
import org.junit.Assert;
import org.junit.Test;

public class RestApiTest
extends ClusterTestHarness {
    private static final Random random = new Random();

    public RestApiTest() {
        super(1, true);
    }

    @Override
    protected Properties getSchemaRegistryProperties() {
        Properties props = new Properties();
        props.setProperty("schema.providers", ProtobufSchemaProvider.class.getName());
        return props;
    }

    @Test
    public void testBasic() throws Exception {
        int i;
        String subject1 = "testTopic1";
        String subject2 = "testTopic2";
        int schemasInSubject1 = 10;
        ArrayList<Integer> allVersionsInSubject1 = new ArrayList<Integer>();
        List<String> allSchemasInSubject1 = RestApiTest.getRandomProtobufSchemas(schemasInSubject1);
        int schemasInSubject2 = 5;
        ArrayList<Integer> allVersionsInSubject2 = new ArrayList<Integer>();
        List<String> allSchemasInSubject2 = RestApiTest.getRandomProtobufSchemas(schemasInSubject2);
        ArrayList<String> allSubjects = new ArrayList<String>();
        Assert.assertEquals((String)"Getting all subjects should return empty", allSubjects, (Object)this.restApp.restClient.getAllSubjects());
        int schemaIdCounter = 1;
        for (i = 0; i < schemasInSubject1; ++i) {
            String schema = allSchemasInSubject1.get(i);
            int expectedVersion = i + 1;
            RestApiTest.registerAndVerifySchema(this.restApp.restClient, schema, schemaIdCounter, subject1);
            ++schemaIdCounter;
            allVersionsInSubject1.add(expectedVersion);
        }
        allSubjects.add(subject1);
        for (i = 0; i < schemasInSubject1; ++i) {
            int expectedId = i + 1;
            String schemaString = allSchemasInSubject1.get(i);
            int foundId = this.restApp.restClient.registerSchema(schemaString, "PROTOBUF", Collections.emptyList(), subject1);
            Assert.assertEquals((String)"Re-registering an existing schema should return the existing version", (long)expectedId, (long)foundId);
        }
        for (i = 0; i < schemasInSubject2; ++i) {
            String schema = allSchemasInSubject2.get(i);
            int expectedVersion = i + 1;
            RestApiTest.registerAndVerifySchema(this.restApp.restClient, schema, schemaIdCounter, subject2);
            ++schemaIdCounter;
            allVersionsInSubject2.add(expectedVersion);
        }
        allSubjects.add(subject2);
        Assert.assertEquals((String)"Getting all versions from subject1 should match all registered versions", allVersionsInSubject1, (Object)this.restApp.restClient.getAllVersions(subject1));
        Assert.assertEquals((String)"Getting all versions from subject2 should match all registered versions", allVersionsInSubject2, (Object)this.restApp.restClient.getAllVersions(subject2));
        Assert.assertEquals((String)"Getting all subjects should match all registered subjects", allSubjects, (Object)this.restApp.restClient.getAllSubjects());
    }

    @Test
    public void testSchemaReferences() throws Exception {
        Map<String, String> schemas = RestApiTest.getProtobufSchemaWithDependencies();
        String subject = "reference";
        RestApiTest.registerAndVerifySchema(this.restApp.restClient, schemas.get("ref.proto"), 1, subject);
        RegisterSchemaRequest request = new RegisterSchemaRequest();
        request.setSchema(schemas.get("root.proto"));
        request.setSchemaType("PROTOBUF");
        SchemaReference ref = new SchemaReference("ref.proto", "reference", Integer.valueOf(1));
        request.setReferences(Collections.singletonList(ref));
        int registeredId = this.restApp.restClient.registerSchema(request, "referrer");
        Assert.assertEquals((String)"Registering a new schema should succeed", (long)2L, (long)registeredId);
        SchemaString schemaString = this.restApp.restClient.getId(2);
        Assert.assertEquals((String)"Registered schema should be found", (Object)schemas.get("root.proto"), (Object)schemaString.getSchemaString());
        Assert.assertEquals((String)"Schema dependencies should be found", Collections.singletonList(ref), (Object)schemaString.getReferences());
        Root.ReferrerMessage referrer = Root.ReferrerMessage.newBuilder().build();
        ProtobufSchema schema = ProtobufSchemaUtils.getSchema((Message)referrer);
        schema = schema.copy(Collections.singletonList(ref));
        Schema registeredSchema = this.restApp.restClient.lookUpSubjectVersion(schema.canonicalString(), "PROTOBUF", schema.references(), "referrer", false);
        Assert.assertEquals((String)"Registered schema should be found", (long)2L, (long)registeredSchema.getId().intValue());
    }

    @Test(expected=RestClientException.class)
    public void testSchemaMissingReferences() throws Exception {
        Map<String, String> schemas = RestApiTest.getProtobufSchemaWithDependencies();
        RegisterSchemaRequest request = new RegisterSchemaRequest();
        request.setSchema(schemas.get("root.proto"));
        request.setSchemaType("PROTOBUF");
        request.setReferences(Collections.emptyList());
        this.restApp.restClient.registerSchema(request, "referrer");
    }

    @Test
    public void testBad() throws Exception {
        String subject1 = "testTopic1";
        ArrayList allSubjects = new ArrayList();
        Assert.assertEquals((String)"Getting all subjects should return empty", allSubjects, (Object)this.restApp.restClient.getAllSubjects());
        try {
            RestApiTest.registerAndVerifySchema(this.restApp.restClient, RestApiTest.getBadSchema(), 1, subject1);
            Assert.fail((String)"Registering bad schema should fail with 42201");
        }
        catch (RestClientException rce) {
            Assert.assertEquals((String)"Invalid schema", (long)42201L, (long)rce.getErrorCode());
        }
        try {
            RestApiTest.registerAndVerifySchema(this.restApp.restClient, RestApiTest.getRandomProtobufSchemas(1).get(0), Arrays.asList(new SchemaReference("bad", "bad", Integer.valueOf(100))), 1, subject1);
            Assert.fail((String)"Registering bad reference should fail with 42201");
        }
        catch (RestClientException rce) {
            Assert.assertEquals((String)"Invalid schema", (long)42201L, (long)rce.getErrorCode());
        }
        Assert.assertEquals((String)"Getting all subjects should match all registered subjects", allSubjects, (Object)this.restApp.restClient.getAllSubjects());
    }

    @Test
    public void testCustomOption() throws Exception {
        String subject = "test-proto";
        String enumOptionSchemaString = "syntax = \"proto3\";\n\nimport \"google/protobuf/descriptor.proto\";\n\noption java_package = \"io.confluent.kafka.serializers.protobuf.test\";\noption java_outer_classname = \"TestEnumProtos\";\noption php_namespace = \"Bug\\\\V1\";\n\nmessage TestEnum {\n  option (some_ref) = \"https://test.com\";\n\n  Suit suit = 1;\n\n  enum Suit {\n    SPADES = 0;\n    HEARTS = 1;\n    DIAMONDS = 2;\n    CLUBS = 3;\n  }\n}\n";
        RestApiTest.registerAndVerifySchema(this.restApp.restClient, enumOptionSchemaString, 1, subject);
    }

    public static void registerAndVerifySchema(RestService restService, String schemaString, int expectedId, String subject) throws IOException, RestClientException {
        RestApiTest.registerAndVerifySchema(restService, schemaString, Collections.emptyList(), expectedId, subject);
    }

    public static void registerAndVerifySchema(RestService restService, String schemaString, List<SchemaReference> references, int expectedId, String subject) throws IOException, RestClientException {
        int registeredId = restService.registerSchema(schemaString, "PROTOBUF", references, subject);
        Assert.assertEquals((String)"Registering a new schema should succeed", (long)expectedId, (long)registeredId);
        Assert.assertEquals((String)"Registered schema should be found", (Object)schemaString, (Object)restService.getId(expectedId).getSchemaString());
    }

    public static List<String> getRandomProtobufSchemas(int num) {
        ArrayList<String> schemas = new ArrayList<String>();
        for (int i = 0; i < num; ++i) {
            String schema = "syntax = \"proto3\";\npackage io.confluent.kafka.serializers.protobuf.test;\n\nmessage MyMessage {\n  string f" + random.nextInt(Integer.MAX_VALUE) + " = 1;\n  bool is_active = 2;\n}\n";
            schemas.add(schema);
        }
        return schemas;
    }

    public static Map<String, String> getProtobufSchemaWithDependencies() {
        HashMap<String, String> schemas = new HashMap<String, String>();
        String reference = "syntax = \"proto3\";\npackage io.confluent.kafka.serializers.protobuf.test;\n\nmessage ReferencedMessage {\n  string ref_id = 1;\n  bool is_active = 2;\n}\n";
        schemas.put("ref.proto", reference);
        String schemaString = "syntax = \"proto3\";\npackage io.confluent.kafka.serializers.protobuf.test;\n\nimport \"ref.proto\";\n\nmessage ReferrerMessage {\n  string root_id = 1;\n  .io.confluent.kafka.serializers.protobuf.test.ReferencedMessage ref = 2;\n}\n";
        schemas.put("root.proto", schemaString);
        return schemas;
    }

    public static String getBadSchema() {
        String schema = "syntax = \"proto3\";\npackage io.confluent.kafka.serializers.protobuf.test;\n\nbad-message MyMessage {\n  string f" + random.nextInt(Integer.MAX_VALUE) + " = 1;\n  bool is_active = 2;\n}\n";
        return schema;
    }
}

