/*
 * Decompiled with CFR 0.152.
 */
package io.confluent.kafka.schemaregistry.storage;

import io.confluent.kafka.schemaregistry.SASLClusterTestHarness;
import io.confluent.kafka.schemaregistry.storage.KafkaStore;
import io.confluent.kafka.schemaregistry.storage.StoreUtils;
import io.confluent.kafka.schemaregistry.storage.exceptions.StoreInitializationException;
import org.junit.Assert;
import org.junit.Test;

public class KafkaStoreSASLTest
extends SASLClusterTestHarness {
    @Test
    public void testInitialization() throws Exception {
        KafkaStore<String, String> kafkaStore = StoreUtils.createAndInitSASLStoreInstance(this.zkConnect);
        kafkaStore.close();
    }

    @Test(expected=StoreInitializationException.class)
    public void testDoubleInitialization() throws Exception {
        try (KafkaStore<String, String> kafkaStore = StoreUtils.createAndInitSASLStoreInstance(this.zkConnect);){
            kafkaStore.init();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testSimplePut() throws Exception {
        KafkaStore<String, String> kafkaStore = StoreUtils.createAndInitSASLStoreInstance(this.zkConnect);
        String key = "Kafka";
        String value = "Rocks";
        try {
            kafkaStore.put((Object)key, (Object)value);
            String retrievedValue = (String)kafkaStore.get((Object)key);
            Assert.assertEquals((String)"Retrieved value should match entered value", (Object)value, (Object)retrievedValue);
        }
        finally {
            kafkaStore.close();
        }
    }
}

