/*
 * Decompiled with CFR 0.152.
 */
package io.confluent.kafka.schemaregistry.id;

import io.confluent.kafka.schemaregistry.client.rest.entities.Schema;
import io.confluent.kafka.schemaregistry.exceptions.IdGenerationException;
import io.confluent.kafka.schemaregistry.id.IdGenerator;
import io.confluent.kafka.schemaregistry.rest.SchemaRegistryConfig;
import io.confluent.kafka.schemaregistry.storage.SchemaKey;
import io.confluent.kafka.schemaregistry.storage.SchemaValue;
import java.util.concurrent.atomic.AtomicInteger;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class IncrementalIdGenerator
implements IdGenerator {
    Logger log = LoggerFactory.getLogger(IncrementalIdGenerator.class);
    private final AtomicInteger maxIdInKafkaStore = new AtomicInteger(0);

    @Override
    public int id(Schema schema) throws IdGenerationException {
        return this.maxIdInKafkaStore.incrementAndGet();
    }

    @Override
    public int getMaxId(int currentId) {
        int maxId = this.maxIdInKafkaStore.get();
        if (currentId > maxId) {
            this.log.debug("Requested ID is greater than max ID");
        }
        return maxId;
    }

    @Override
    public void configure(SchemaRegistryConfig config) {
    }

    @Override
    public void init() throws IdGenerationException {
    }

    @Override
    public void schemaRegistered(SchemaKey schemaKey, SchemaValue schemaValue) {
        if (this.maxIdInKafkaStore.get() < schemaValue.getId()) {
            this.maxIdInKafkaStore.set(schemaValue.getId());
        }
    }
}

