/*
 * Decompiled with CFR 0.152.
 */
package io.confluent.kafka.schemaregistry.id;

import io.confluent.kafka.schemaregistry.client.rest.entities.Schema;
import io.confluent.kafka.schemaregistry.exceptions.IdGenerationException;
import io.confluent.kafka.schemaregistry.id.IdGenerator;
import io.confluent.kafka.schemaregistry.id.SchemaIdRange;
import io.confluent.kafka.schemaregistry.rest.SchemaRegistryConfig;
import io.confluent.kafka.schemaregistry.storage.SchemaKey;
import io.confluent.kafka.schemaregistry.storage.SchemaValue;
import io.confluent.kafka.schemaregistry.utils.ZkData;
import io.confluent.kafka.schemaregistry.utils.ZkUtils;
import org.I0Itec.zkclient.exception.ZkNodeExistsException;
import org.apache.zookeeper.data.Stat;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ZookeeperIdGenerator
implements IdGenerator {
    public static final int ZOOKEEPER_SCHEMA_ID_COUNTER_BATCH_SIZE = 20;
    public static final String ZOOKEEPER_SCHEMA_ID_COUNTER = "/schema_id_counter";
    private static final Logger log = LoggerFactory.getLogger(ZookeeperIdGenerator.class);
    private static final int ZOOKEEPER_SCHEMA_ID_COUNTER_BATCH_WRITE_RETRY_BACKOFF_MS = 50;
    private ZkUtils zkUtils;
    private int nextAvailableSchemaId;
    private int idBatchInclusiveUpperBound;
    private int maxIdInKafkaStore = -1;

    @Override
    public int id(Schema schema) throws IdGenerationException {
        int id = this.nextAvailableSchemaId++;
        if (this.reachedEndOfIdBatch()) {
            this.init();
        }
        return id;
    }

    @Override
    public int getMaxId(int currentId) {
        if (currentId > this.maxIdInKafkaStore) {
            log.debug("Requested ID is greater than max ID");
        }
        return this.maxIdInKafkaStore;
    }

    @Override
    public void configure(SchemaRegistryConfig config) {
        this.zkUtils = config.zkUtils();
    }

    @Override
    public void init() throws IdGenerationException {
        SchemaIdRange nextRange = this.nextRange();
        this.nextAvailableSchemaId = nextRange.base();
        this.idBatchInclusiveUpperBound = nextRange.end();
    }

    @Override
    public void schemaRegistered(SchemaKey schemaKey, SchemaValue schemaValue) {
        if (this.maxIdInKafkaStore < schemaValue.getId()) {
            this.maxIdInKafkaStore = schemaValue.getId();
        }
    }

    private SchemaIdRange nextRange() throws IdGenerationException {
        int base = this.nextSchemaIdCounterBatch();
        return new SchemaIdRange(base, this.getInclusiveUpperBound(base));
    }

    private Integer nextSchemaIdCounterBatch() throws IdGenerationException {
        int nextIdBatchLowerBound = 1;
        while (true) {
            if (!this.zkUtils.zkClient().exists(ZOOKEEPER_SCHEMA_ID_COUNTER)) {
                try {
                    nextIdBatchLowerBound = this.getNextBatchLowerBoundFromKafkaStore();
                    int nextIdBatchUpperBound = this.getInclusiveUpperBound(nextIdBatchLowerBound);
                    this.zkUtils.createPersistentPath(ZOOKEEPER_SCHEMA_ID_COUNTER, String.valueOf(nextIdBatchUpperBound));
                    return nextIdBatchLowerBound;
                }
                catch (ZkNodeExistsException nextIdBatchUpperBound) {}
            } else {
                String nextIdBatchUpperBound;
                int newSchemaIdCounterDataVersion;
                ZkData counterValue = this.zkUtils.readData(ZOOKEEPER_SCHEMA_ID_COUNTER);
                String counterData = counterValue.getData();
                Stat counterStat = counterValue.getStat();
                if (counterData == null) {
                    throw new IdGenerationException("Failed to read schema id counter /schema_id_counter from zookeeper");
                }
                int zkIdCounterValue = Integer.parseInt(counterData);
                int zkNextIdBatchLowerBound = zkIdCounterValue + 1;
                if (zkIdCounterValue % 20 != 0) {
                    int fixedZkIdCounterValue = 20 * (1 + zkIdCounterValue / 20);
                    zkNextIdBatchLowerBound = fixedZkIdCounterValue + 1;
                    log.warn("Zookeeper schema id counter is not an integer multiple of id batch size. Zookeeper may have stale id counter data.\nzk id counter: " + zkIdCounterValue + "\nid batch size: " + 20);
                }
                if ((newSchemaIdCounterDataVersion = Integer.valueOf(this.zkUtils.conditionalUpdatePersistentPath(ZOOKEEPER_SCHEMA_ID_COUNTER, nextIdBatchUpperBound = String.valueOf(this.getInclusiveUpperBound(nextIdBatchLowerBound = Math.max(zkNextIdBatchLowerBound, this.getNextBatchLowerBoundFromKafkaStore()))), counterStat.getVersion())).intValue()) >= 0) break;
            }
            try {
                Thread.sleep(50L);
            }
            catch (InterruptedException interruptedException) {}
        }
        return nextIdBatchLowerBound;
    }

    private int getNextBatchLowerBoundFromKafkaStore() {
        if (this.maxIdInKafkaStore <= 0) {
            return 1;
        }
        int nextBatchLowerBound = 1 + this.maxIdInKafkaStore / 20;
        return 1 + nextBatchLowerBound * 20;
    }

    private int getInclusiveUpperBound(int inclusiveLowerBound) {
        return inclusiveLowerBound + 20 - 1;
    }

    private boolean reachedEndOfIdBatch() {
        return this.nextAvailableSchemaId > this.idBatchInclusiveUpperBound;
    }
}

