/*
 * Decompiled with CFR 0.152.
 */
package io.confluent.kafka.schemaregistry.leaderelector.kafka;

import io.confluent.kafka.schemaregistry.leaderelector.kafka.SchemaRegistryCoordinator;
import io.confluent.kafka.schemaregistry.leaderelector.kafka.SchemaRegistryProtocol;
import io.confluent.kafka.schemaregistry.leaderelector.kafka.SchemaRegistryRebalanceListener;
import io.confluent.kafka.schemaregistry.storage.SchemaRegistryIdentity;
import java.nio.ByteBuffer;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.kafka.clients.KafkaClient;
import org.apache.kafka.clients.Metadata;
import org.apache.kafka.clients.MockClient;
import org.apache.kafka.clients.consumer.internals.ConsumerNetworkClient;
import org.apache.kafka.common.Cluster;
import org.apache.kafka.common.Node;
import org.apache.kafka.common.internals.ClusterResourceListeners;
import org.apache.kafka.common.message.JoinGroupRequestData;
import org.apache.kafka.common.message.JoinGroupResponseData;
import org.apache.kafka.common.message.SyncGroupResponseData;
import org.apache.kafka.common.metrics.Metrics;
import org.apache.kafka.common.protocol.Errors;
import org.apache.kafka.common.requests.AbstractRequest;
import org.apache.kafka.common.requests.AbstractResponse;
import org.apache.kafka.common.requests.FindCoordinatorResponse;
import org.apache.kafka.common.requests.JoinGroupResponse;
import org.apache.kafka.common.requests.SyncGroupRequest;
import org.apache.kafka.common.requests.SyncGroupResponse;
import org.apache.kafka.common.utils.LogContext;
import org.apache.kafka.common.utils.MockTime;
import org.apache.kafka.common.utils.Time;
import org.apache.kafka.test.TestUtils;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;

public class SchemaRegistryCoordinatorTest {
    private static final String LEADER_ID = "leader";
    private static final String MEMBER_ID = "member";
    private static final String LEADER_HOST = "leaderHost";
    private static final int LEADER_PORT = 8083;
    private static final SchemaRegistryIdentity LEADER_INFO = new SchemaRegistryIdentity("leaderHost", Integer.valueOf(8083), Boolean.valueOf(true), "http");
    private static final SchemaRegistryIdentity INELIGIBLE_LEADER_INFO = new SchemaRegistryIdentity("leaderHost", Integer.valueOf(8083), Boolean.valueOf(false), "http");
    private String groupId = "test-group";
    private int sessionTimeoutMs = 10;
    private int rebalanceTimeoutMs = 60;
    private int heartbeatIntervalMs = 2;
    private long retryBackoffMs = 100L;
    private MockTime time;
    private MockClient client;
    private Cluster cluster = TestUtils.singletonCluster((String)"topic", (int)1);
    private Node node = (Node)this.cluster.nodes().get(0);
    private Metadata metadata;
    private Metrics metrics;
    private ConsumerNetworkClient consumerClient;
    private MockRebalanceListener rebalanceListener;
    private SchemaRegistryCoordinator coordinator;

    @Before
    public void setup() {
        this.time = new MockTime();
        this.metadata = new Metadata(0L, Long.MAX_VALUE, new LogContext(), new ClusterResourceListeners());
        this.client = new MockClient((Time)this.time, new MockClient.MockMetadataUpdater(){

            public List<Node> fetchNodes() {
                return SchemaRegistryCoordinatorTest.this.cluster.nodes();
            }

            public boolean isUpdateNeeded() {
                return false;
            }

            public void update(Time time, MockClient.MetadataUpdate update) {
                throw new UnsupportedOperationException();
            }
        });
        LogContext logContext = new LogContext();
        this.consumerClient = new ConsumerNetworkClient(logContext, (KafkaClient)this.client, this.metadata, (Time)this.time, 100L, 1000, Integer.MAX_VALUE);
        this.metrics = new Metrics((Time)this.time);
        this.rebalanceListener = new MockRebalanceListener();
        this.coordinator = new SchemaRegistryCoordinator(logContext, this.consumerClient, this.groupId, this.rebalanceTimeoutMs, this.sessionTimeoutMs, this.heartbeatIntervalMs, this.metrics, "sr-" + this.groupId, (Time)this.time, this.retryBackoffMs, LEADER_INFO, (SchemaRegistryRebalanceListener)this.rebalanceListener, null);
    }

    @After
    public void teardown() {
        this.metrics.close();
    }

    @Test
    public void testMetadata() {
        JoinGroupRequestData.JoinGroupRequestProtocolCollection serialized = this.coordinator.metadata();
        Assert.assertEquals((long)1L, (long)serialized.size());
        JoinGroupRequestData.JoinGroupRequestProtocol defaultMetadata = (JoinGroupRequestData.JoinGroupRequestProtocol)serialized.iterator().next();
        Assert.assertEquals((Object)"v0", (Object)defaultMetadata.name());
        SchemaRegistryIdentity state = SchemaRegistryProtocol.deserializeMetadata((ByteBuffer)ByteBuffer.wrap(defaultMetadata.metadata()));
        Assert.assertEquals((Object)LEADER_INFO, (Object)state);
    }

    @Test
    public void testNormalJoinGroupLeader() {
        String consumerId = LEADER_ID;
        this.client.prepareResponse((AbstractResponse)this.groupCoordinatorResponse(this.node, Errors.NONE));
        this.coordinator.ensureCoordinatorReady(this.time.timer(Long.MAX_VALUE));
        Map<String, SchemaRegistryIdentity> memberInfo = Collections.singletonMap(LEADER_ID, LEADER_INFO);
        this.client.prepareResponse((AbstractResponse)this.joinGroupLeaderResponse(1, LEADER_ID, memberInfo, Errors.NONE));
        SyncGroupResponse syncGroupResponse = this.syncGroupResponse((short)0, LEADER_ID, LEADER_INFO, Errors.NONE);
        this.client.prepareResponse(new MockClient.RequestMatcher(){

            public boolean matches(AbstractRequest body) {
                SyncGroupRequest sync = (SyncGroupRequest)body;
                return sync.data.memberId().equals(SchemaRegistryCoordinatorTest.LEADER_ID) && sync.data.generationId() == 1 && sync.groupAssignments().containsKey(SchemaRegistryCoordinatorTest.LEADER_ID);
            }
        }, (AbstractResponse)syncGroupResponse);
        this.coordinator.ensureActiveGroup();
        Assert.assertFalse((boolean)this.coordinator.rejoinNeededOrPending());
        Assert.assertEquals((long)0L, (long)this.rebalanceListener.revokedCount);
        Assert.assertEquals((long)1L, (long)this.rebalanceListener.assignedCount);
        Assert.assertFalse((boolean)this.rebalanceListener.assignments.get(0).failed());
        Assert.assertEquals((Object)LEADER_ID, (Object)this.rebalanceListener.assignments.get(0).leader());
        Assert.assertEquals((Object)LEADER_INFO, (Object)this.rebalanceListener.assignments.get(0).leaderIdentity());
    }

    @Test
    public void testJoinGroupLeaderNoneEligible() {
        String consumerId = LEADER_ID;
        this.client.prepareResponse((AbstractResponse)this.groupCoordinatorResponse(this.node, Errors.NONE));
        this.coordinator.ensureCoordinatorReady(this.time.timer(Long.MAX_VALUE));
        Map<String, SchemaRegistryIdentity> memberInfo = Collections.singletonMap(LEADER_ID, INELIGIBLE_LEADER_INFO);
        this.client.prepareResponse((AbstractResponse)this.joinGroupLeaderResponse(1, LEADER_ID, memberInfo, Errors.NONE));
        SyncGroupResponse syncGroupResponse = this.syncGroupResponse((short)0, null, null, Errors.NONE);
        this.client.prepareResponse(new MockClient.RequestMatcher(){

            public boolean matches(AbstractRequest body) {
                SyncGroupRequest sync = (SyncGroupRequest)body;
                return sync.data.memberId().equals(SchemaRegistryCoordinatorTest.LEADER_ID) && sync.data.generationId() == 1 && sync.groupAssignments().containsKey(SchemaRegistryCoordinatorTest.LEADER_ID);
            }
        }, (AbstractResponse)syncGroupResponse);
        this.coordinator.ensureActiveGroup();
        Assert.assertFalse((boolean)this.coordinator.rejoinNeededOrPending());
        Assert.assertEquals((long)0L, (long)this.rebalanceListener.revokedCount);
        Assert.assertEquals((long)1L, (long)this.rebalanceListener.assignedCount);
        Assert.assertFalse((boolean)this.rebalanceListener.assignments.get(0).failed());
        Assert.assertNull((Object)this.rebalanceListener.assignments.get(0).leader());
        Assert.assertNull((Object)this.rebalanceListener.assignments.get(0).leaderIdentity());
    }

    @Test
    public void testJoinGroupLeaderDuplicateUrls() {
        String consumerId = LEADER_ID;
        this.client.prepareResponse((AbstractResponse)this.groupCoordinatorResponse(this.node, Errors.NONE));
        this.coordinator.ensureCoordinatorReady(this.time.timer(Long.MAX_VALUE));
        HashMap<String, SchemaRegistryIdentity> memberInfo = new HashMap<String, SchemaRegistryIdentity>();
        memberInfo.put(LEADER_ID, LEADER_INFO);
        memberInfo.put(MEMBER_ID, LEADER_INFO);
        this.client.prepareResponse((AbstractResponse)this.joinGroupLeaderResponse(1, LEADER_ID, memberInfo, Errors.NONE));
        SyncGroupResponse syncGroupResponse = this.syncGroupResponse((short)1, null, null, Errors.NONE);
        this.client.prepareResponse(new MockClient.RequestMatcher(){

            public boolean matches(AbstractRequest body) {
                SyncGroupRequest sync = (SyncGroupRequest)body;
                return sync.data.memberId().equals(SchemaRegistryCoordinatorTest.LEADER_ID) && sync.data.generationId() == 1 && sync.groupAssignments().containsKey(SchemaRegistryCoordinatorTest.LEADER_ID);
            }
        }, (AbstractResponse)syncGroupResponse);
        this.coordinator.ensureActiveGroup();
        Assert.assertFalse((boolean)this.coordinator.rejoinNeededOrPending());
        Assert.assertEquals((long)0L, (long)this.rebalanceListener.revokedCount);
        Assert.assertEquals((long)1L, (long)this.rebalanceListener.assignedCount);
        Assert.assertTrue((boolean)this.rebalanceListener.assignments.get(0).failed());
        Assert.assertNull((Object)this.rebalanceListener.assignments.get(0).leader());
        Assert.assertNull((Object)this.rebalanceListener.assignments.get(0).leaderIdentity());
    }

    @Test
    public void testNormalJoinGroupFollower() {
        String consumerId = MEMBER_ID;
        this.client.prepareResponse((AbstractResponse)this.groupCoordinatorResponse(this.node, Errors.NONE));
        this.coordinator.ensureCoordinatorReady(this.time.timer(Long.MAX_VALUE));
        this.client.prepareResponse((AbstractResponse)this.joinGroupFollowerResponse(1, MEMBER_ID, LEADER_ID, Errors.NONE));
        SyncGroupResponse syncGroupResponse = this.syncGroupResponse((short)0, LEADER_ID, LEADER_INFO, Errors.NONE);
        this.client.prepareResponse(new MockClient.RequestMatcher(){

            public boolean matches(AbstractRequest body) {
                SyncGroupRequest sync = (SyncGroupRequest)body;
                return sync.data.memberId().equals(SchemaRegistryCoordinatorTest.MEMBER_ID) && sync.data.generationId() == 1 && sync.groupAssignments().isEmpty();
            }
        }, (AbstractResponse)syncGroupResponse);
        this.coordinator.ensureActiveGroup();
        Assert.assertFalse((boolean)this.coordinator.rejoinNeededOrPending());
        Assert.assertEquals((long)0L, (long)this.rebalanceListener.revokedCount);
        Assert.assertEquals((long)1L, (long)this.rebalanceListener.assignedCount);
        Assert.assertFalse((boolean)this.rebalanceListener.assignments.get(0).failed());
        Assert.assertEquals((Object)LEADER_ID, (Object)this.rebalanceListener.assignments.get(0).leader());
        Assert.assertEquals((Object)LEADER_INFO, (Object)this.rebalanceListener.assignments.get(0).leaderIdentity());
    }

    private FindCoordinatorResponse groupCoordinatorResponse(Node node, Errors error) {
        return FindCoordinatorResponse.prepareResponse((Errors)error, (Node)node);
    }

    private JoinGroupResponse joinGroupLeaderResponse(int generationId, String memberId, Map<String, SchemaRegistryIdentity> memberLeaderEligibility, Errors error) {
        ArrayList<JoinGroupResponseData.JoinGroupResponseMember> metadata = new ArrayList<JoinGroupResponseData.JoinGroupResponseMember>();
        for (Map.Entry<String, SchemaRegistryIdentity> configStateEntry : memberLeaderEligibility.entrySet()) {
            SchemaRegistryIdentity memberIdentity = configStateEntry.getValue();
            ByteBuffer buf = SchemaRegistryProtocol.serializeMetadata((SchemaRegistryIdentity)memberIdentity);
            metadata.add(new JoinGroupResponseData.JoinGroupResponseMember().setMemberId(configStateEntry.getKey()).setMetadata(buf.array()));
        }
        return new JoinGroupResponse(new JoinGroupResponseData().setErrorCode(error.code()).setGenerationId(generationId).setProtocolName("v0").setMemberId(memberId).setLeader(memberId).setMembers(metadata));
    }

    private JoinGroupResponse joinGroupFollowerResponse(int generationId, String memberId, String leaderId, Errors error) {
        return new JoinGroupResponse(new JoinGroupResponseData().setErrorCode(error.code()).setGenerationId(generationId).setProtocolName("v0").setMemberId(memberId).setLeader(leaderId).setMembers(Collections.emptyList()));
    }

    private SyncGroupResponse syncGroupResponse(short assignmentError, String leader, SchemaRegistryIdentity leaderIdentity, Errors error) {
        SchemaRegistryProtocol.Assignment assignment = new SchemaRegistryProtocol.Assignment(assignmentError, leader, leaderIdentity);
        ByteBuffer buf = SchemaRegistryProtocol.serializeAssignment((SchemaRegistryProtocol.Assignment)assignment);
        return new SyncGroupResponse(new SyncGroupResponseData().setErrorCode(error.code()).setAssignment(buf.array()));
    }

    private static class MockRebalanceListener
    implements SchemaRegistryRebalanceListener {
        public List<SchemaRegistryProtocol.Assignment> assignments = new ArrayList<SchemaRegistryProtocol.Assignment>();
        public int revokedCount = 0;
        public int assignedCount = 0;

        private MockRebalanceListener() {
        }

        public void onAssigned(SchemaRegistryProtocol.Assignment assignment, int generation) {
            this.assignments.add(assignment);
            ++this.assignedCount;
        }

        public void onRevoked() {
            ++this.revokedCount;
        }
    }
}

