/*
 * Decompiled with CFR 0.152.
 */
package io.confluent.kafka.schemaregistry.storage;

import io.confluent.kafka.schemaregistry.exceptions.SchemaRegistryException;
import io.confluent.kafka.schemaregistry.rest.SchemaRegistryConfig;
import io.confluent.kafka.schemaregistry.storage.InMemoryCache;
import io.confluent.kafka.schemaregistry.storage.KafkaStore;
import io.confluent.kafka.schemaregistry.storage.NoopKey;
import io.confluent.kafka.schemaregistry.storage.Store;
import io.confluent.kafka.schemaregistry.storage.StoreUpdateHandler;
import io.confluent.kafka.schemaregistry.storage.StringMessageHandler;
import io.confluent.kafka.schemaregistry.storage.StringSerializer;
import io.confluent.kafka.schemaregistry.storage.exceptions.StoreInitializationException;
import io.confluent.kafka.schemaregistry.storage.serialization.Serializer;
import io.confluent.rest.RestConfigException;
import java.util.Map;
import java.util.Properties;
import org.apache.kafka.common.config.types.Password;
import org.apache.kafka.common.security.auth.SecurityProtocol;

public class StoreUtils {
    public static KafkaStore<String, String> createAndInitKafkaStoreInstance(String bootstrapServers) throws RestConfigException, StoreInitializationException, SchemaRegistryException {
        InMemoryCache inMemoryStore = new InMemoryCache((Serializer)StringSerializer.INSTANCE);
        return StoreUtils.createAndInitKafkaStoreInstance(bootstrapServers, (Store<String, String>)inMemoryStore);
    }

    public static KafkaStore<String, String> createAndInitKafkaStoreInstance(String bootstrapServers, Store<String, String> inMemoryStore) throws RestConfigException, StoreInitializationException, SchemaRegistryException {
        return StoreUtils.createAndInitKafkaStoreInstance(bootstrapServers, inMemoryStore, new Properties());
    }

    public static KafkaStore<String, String> createAndInitSASLStoreInstance(String bootstrapServers) throws RestConfigException, StoreInitializationException, SchemaRegistryException {
        Properties props = new Properties();
        props.put("kafkastore.security.protocol", SecurityProtocol.SASL_PLAINTEXT.toString());
        props.put("zookeeper.set.acl", (Object)false);
        InMemoryCache inMemoryStore = new InMemoryCache((Serializer)StringSerializer.INSTANCE);
        return StoreUtils.createAndInitKafkaStoreInstance(bootstrapServers, (Store<String, String>)inMemoryStore, props);
    }

    public static KafkaStore<String, String> createAndInitSSLKafkaStoreInstance(String bootstrapServers, Map<String, Object> sslConfigs, boolean requireSSLClientAuth) throws RestConfigException, StoreInitializationException, SchemaRegistryException {
        Properties props = new Properties();
        props.put("kafkastore.security.protocol", SecurityProtocol.SSL.toString());
        props.put("kafkastore.ssl.truststore.location", sslConfigs.get("ssl.truststore.location"));
        props.put("kafkastore.ssl.truststore.password", ((Password)sslConfigs.get("ssl.truststore.password")).value());
        if (requireSSLClientAuth) {
            props.put("kafkastore.ssl.keystore.location", sslConfigs.get("ssl.keystore.location"));
            props.put("kafkastore.ssl.keystore.password", ((Password)sslConfigs.get("ssl.keystore.password")).value());
            props.put("kafkastore.ssl.key.password", ((Password)sslConfigs.get("ssl.key.password")).value());
        }
        InMemoryCache inMemoryStore = new InMemoryCache((Serializer)StringSerializer.INSTANCE);
        return StoreUtils.createAndInitKafkaStoreInstance(bootstrapServers, (Store<String, String>)inMemoryStore, props);
    }

    public static KafkaStore<String, String> createAndInitKafkaStoreInstance(String bootstrapServers, Store<String, String> inMemoryStore, Properties props) throws RestConfigException, StoreInitializationException, SchemaRegistryException {
        props.put("kafkastore.bootstrap.servers", bootstrapServers);
        props.put("kafkastore.topic", "_schemas");
        SchemaRegistryConfig config = null;
        config = new SchemaRegistryConfig(props);
        KafkaStore kafkaStore = new KafkaStore(config, (StoreUpdateHandler)new StringMessageHandler(), (Serializer)StringSerializer.INSTANCE, inMemoryStore, (Object)new NoopKey().toString());
        kafkaStore.init();
        return kafkaStore;
    }
}

