/*
 * Decompiled with CFR 0.152.
 */
package io.confluent.kafka.schemaregistry.storage;

import io.confluent.kafka.schemaregistry.storage.SchemaRegistryKey;
import io.confluent.kafka.schemaregistry.storage.SchemaRegistryValue;
import io.confluent.kafka.schemaregistry.storage.SchemaUpdateHandler;
import io.confluent.kafka.schemaregistry.storage.StoreUpdateHandler;
import java.io.IOException;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.kafka.common.TopicPartition;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CompositeSchemaUpdateHandler
implements SchemaUpdateHandler {
    private static final Logger log = LoggerFactory.getLogger(CompositeSchemaUpdateHandler.class);
    private final List<SchemaUpdateHandler> handlers;

    public CompositeSchemaUpdateHandler(List<SchemaUpdateHandler> handlers) {
        this.handlers = handlers;
    }

    @Override
    public void cacheInitialized() {
        for (SchemaUpdateHandler handler : this.handlers) {
            handler.cacheInitialized();
        }
    }

    @Override
    public StoreUpdateHandler.ValidationStatus validateUpdate(SchemaRegistryKey key, SchemaRegistryValue value, TopicPartition tp, long offset, long timestamp) {
        for (SchemaUpdateHandler handler : this.handlers) {
            StoreUpdateHandler.ValidationStatus status = handler.validateUpdate(key, value, tp, offset, timestamp);
            if (status == StoreUpdateHandler.ValidationStatus.SUCCESS) continue;
            return status;
        }
        return StoreUpdateHandler.ValidationStatus.SUCCESS;
    }

    @Override
    public void handleUpdate(SchemaRegistryKey key, SchemaRegistryValue value, SchemaRegistryValue oldValue, TopicPartition tp, long offset, long timestamp) {
        for (SchemaUpdateHandler handler : this.handlers) {
            handler.handleUpdate(key, value, oldValue, tp, offset, timestamp);
        }
    }

    @Override
    public Map<TopicPartition, Long> checkpoint(int count) {
        HashMap<TopicPartition, Long> result = null;
        for (SchemaUpdateHandler handler : this.handlers) {
            Map<TopicPartition, Long> offsets = handler.checkpoint(count);
            if (offsets == null) continue;
            if (result != null) {
                for (Map.Entry<TopicPartition, Long> entry : offsets.entrySet()) {
                    result.merge(entry.getKey(), entry.getValue(), Long::min);
                }
                continue;
            }
            result = new HashMap<TopicPartition, Long>(offsets);
        }
        return result;
    }

    @Override
    public void close() throws IOException {
        for (SchemaUpdateHandler handler : this.handlers) {
            handler.close();
        }
    }
}

