/*
 * Decompiled with CFR 0.152.
 */
package io.confluent.kafka.schemaregistry.rest;

import io.confluent.kafka.schemaregistry.rest.SchemaRegistryConfig;
import io.confluent.kafka.schemaregistry.rest.SchemaRegistryRestApplication;
import io.confluent.kafka.schemaregistry.utils.AppInfoParser;
import io.confluent.rest.RestConfigException;
import java.io.IOException;
import org.eclipse.jetty.server.Server;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SchemaRegistryMain {
    private static final Logger log = LoggerFactory.getLogger(SchemaRegistryMain.class);

    public static void main(String[] args) throws IOException {
        try {
            if (args.length != 1) {
                log.error("Properties file is required to start the schema registry REST instance");
                System.exit(1);
            }
            SchemaRegistryConfig config = new SchemaRegistryConfig(args[0]);
            SchemaRegistryRestApplication app = new SchemaRegistryRestApplication(config);
            Server server = app.createServer();
            server.start();
            log.info("Schema Registry version: {} commitId: {}", (Object)AppInfoParser.getVersion(), (Object)AppInfoParser.getCommitId());
            log.info("Server started, listening for requests...");
            server.join();
        }
        catch (RestConfigException e) {
            log.error("Server configuration failed: ", (Throwable)e);
            System.exit(1);
        }
        catch (Exception e) {
            log.error("Server died unexpectedly: ", (Throwable)e);
            System.exit(1);
        }
    }
}

