/*
 * Decompiled with CFR 0.152.
 */
package io.confluent.kafka.schemaregistry.metrics;

import java.util.concurrent.atomic.AtomicLong;
import org.apache.kafka.common.MetricName;
import org.apache.kafka.common.metrics.MeasurableStat;
import org.apache.kafka.common.metrics.Metrics;
import org.apache.kafka.common.metrics.Sensor;
import org.apache.kafka.common.metrics.stats.Value;

public class SchemaRegistryMetric {
    private final AtomicLong count = new AtomicLong();
    private final Sensor sensor;

    public SchemaRegistryMetric(Metrics metrics, String sensorName, MetricName metricName) {
        this.sensor = metrics.sensor(sensorName);
        this.sensor.add(metricName, (MeasurableStat)new Value());
    }

    public void increment() {
        this.sensor.record((double)this.count.addAndGet(1L));
    }

    public void set(long value) {
        this.count.set(value);
        this.sensor.record((double)value);
    }

    public long get() {
        return this.count.get();
    }
}

