/*
 * Decompiled with CFR 0.152.
 */
package io.confluent.kafka.schemaregistry.rest.resources;

import io.confluent.kafka.schemaregistry.client.rest.entities.requests.RegisterSchemaRequest;
import io.confluent.kafka.schemaregistry.exceptions.InvalidSchemaException;
import io.confluent.kafka.schemaregistry.exceptions.OperationNotPermittedException;
import io.confluent.kafka.schemaregistry.exceptions.ReferenceExistsException;
import io.confluent.kafka.schemaregistry.exceptions.SchemaRegistryException;
import io.confluent.kafka.schemaregistry.exceptions.SchemaRegistryStoreException;
import io.confluent.kafka.schemaregistry.exceptions.SchemaRegistryTimeoutException;
import io.confluent.kafka.schemaregistry.exceptions.SubjectNotSoftDeletedException;
import io.confluent.kafka.schemaregistry.rest.exceptions.Errors;
import io.confluent.kafka.schemaregistry.rest.resources.RequestHeaderBuilder;
import io.confluent.kafka.schemaregistry.storage.KafkaSchemaRegistry;
import io.confluent.kafka.schemaregistry.utils.QualifiedSubject;
import io.confluent.rest.annotations.PerformanceMetric;
import io.swagger.v3.oas.annotations.Operation;
import io.swagger.v3.oas.annotations.Parameter;
import io.swagger.v3.oas.annotations.media.ArraySchema;
import io.swagger.v3.oas.annotations.media.Content;
import io.swagger.v3.oas.annotations.media.Schema;
import io.swagger.v3.oas.annotations.responses.ApiResponse;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.validation.Valid;
import javax.validation.constraints.NotNull;
import javax.ws.rs.Consumes;
import javax.ws.rs.DELETE;
import javax.ws.rs.DefaultValue;
import javax.ws.rs.GET;
import javax.ws.rs.POST;
import javax.ws.rs.Path;
import javax.ws.rs.PathParam;
import javax.ws.rs.Produces;
import javax.ws.rs.QueryParam;
import javax.ws.rs.container.AsyncResponse;
import javax.ws.rs.container.Suspended;
import javax.ws.rs.core.Context;
import javax.ws.rs.core.HttpHeaders;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Path(value="/subjects")
@Produces(value={"application/vnd.schemaregistry.v1+json", "application/vnd.schemaregistry+json; qs=0.9", "application/json; qs=0.5"})
@Consumes(value={"application/vnd.schemaregistry.v1+json", "application/vnd.schemaregistry+json", "application/json", "application/octet-stream"})
public class SubjectsResource {
    private static final Logger log = LoggerFactory.getLogger(SubjectsResource.class);
    private final KafkaSchemaRegistry schemaRegistry;
    private final RequestHeaderBuilder requestHeaderBuilder = new RequestHeaderBuilder();

    public SubjectsResource(KafkaSchemaRegistry schemaRegistry) {
        this.schemaRegistry = schemaRegistry;
    }

    @POST
    @Path(value="/{subject}")
    @Operation(summary="Lookup schema under subject", description="Check if a schema has already been registered under the specified subject. If so, this returns the schema string along with its globally unique identifier, its version under this subject and the subject name.", responses={@ApiResponse(responseCode="200", description="The schema", content={@Content(schema=@Schema(implementation=io.confluent.kafka.schemaregistry.client.rest.entities.Schema.class))}), @ApiResponse(responseCode="404", description="Error code 40401 -- Subject not found\nError code 40403 -- Schema not found"), @ApiResponse(responseCode="500", description="Internal server error")})
    @PerformanceMetric(value="subjects.get-schema")
    public void lookUpSchemaUnderSubject(@Suspended AsyncResponse asyncResponse, @Parameter(description="Subject under which the schema will be registered", required=true) @PathParam(value="subject") String subject, @Parameter(description="Whether to lookup the normalized schema") @QueryParam(value="normalize") boolean normalize, @Parameter(description="Whether to lookup deleted schemas") @QueryParam(value="deleted") boolean lookupDeletedSchema, @Parameter(description="Schema", required=true) @NotNull RegisterSchemaRequest request) {
        io.confluent.kafka.schemaregistry.client.rest.entities.Schema matchingSchema;
        log.info("Schema lookup under subject {}, deleted {}, type {}", new Object[]{subject, lookupDeletedSchema, request.getSchemaType()});
        subject = QualifiedSubject.normalize((String)this.schemaRegistry.tenant(), (String)subject);
        io.confluent.kafka.schemaregistry.client.rest.entities.Schema schema = new io.confluent.kafka.schemaregistry.client.rest.entities.Schema(subject, Integer.valueOf(0), Integer.valueOf(-1), request.getSchemaType() != null ? request.getSchemaType() : "AVRO", request.getReferences(), request.getSchema());
        try {
            matchingSchema = this.schemaRegistry.lookUpSchemaUnderSubjectUsingContexts(subject, schema, normalize, lookupDeletedSchema);
            if (matchingSchema == null) {
                if (!this.schemaRegistry.hasSubjects(subject, lookupDeletedSchema)) {
                    throw Errors.subjectNotFoundException(subject);
                }
                throw Errors.schemaNotFoundException();
            }
        }
        catch (InvalidSchemaException e) {
            throw Errors.invalidSchemaException(e);
        }
        catch (SchemaRegistryException e) {
            throw Errors.schemaRegistryException("Error while looking up schema under subject " + subject, e);
        }
        asyncResponse.resume((Object)matchingSchema);
    }

    @GET
    @Valid
    @Operation(summary="List subjects", description="Retrieves a list of registered subjects matching specified parameters.", responses={@ApiResponse(responseCode="200", description="The subjects matching the specified parameters", content={@Content(array=@ArraySchema(schema=@Schema(implementation=String.class)))}), @ApiResponse(responseCode="500", description="Error code 50001 -- Error in the backend datastore")})
    @PerformanceMetric(value="subjects.list")
    public Set<String> list(@DefaultValue(value=":*:") @Parameter(description="Subject name prefix") @QueryParam(value="subjectPrefix") String subjectPrefix, @Parameter(description="Whether to look up deleted subjects") @QueryParam(value="deleted") boolean lookupDeletedSubjects) {
        try {
            return this.schemaRegistry.listSubjectsWithPrefix(subjectPrefix != null ? subjectPrefix : ":*:", lookupDeletedSubjects);
        }
        catch (SchemaRegistryStoreException e) {
            throw Errors.storeException("Error while listing subjects", e);
        }
        catch (SchemaRegistryException e) {
            throw Errors.schemaRegistryException("Error while listing subjects", e);
        }
    }

    @DELETE
    @Path(value="/{subject}")
    @Operation(summary="Delete subject", description="Deletes the specified subject and its associated compatibility level if registered. It is recommended to use this API only when a topic needs to be recycled or in development environment.", responses={@ApiResponse(responseCode="200", description="Operation succeeded. Returns list of schema versions deleted", content={@Content(array=@ArraySchema(schema=@Schema(implementation=int.class)))}), @ApiResponse(responseCode="404", description="Error code 40401 -- Subject not found"), @ApiResponse(responseCode="500", description="Error code 50001 -- Error in the backend datastore")})
    @PerformanceMetric(value="subjects.delete-subject")
    public void deleteSubject(@Suspended AsyncResponse asyncResponse, @Context HttpHeaders headers, @Parameter(description="Name of the subject", required=true) @PathParam(value="subject") String subject, @Parameter(description="Whether to perform a permanent delete") @QueryParam(value="permanent") boolean permanentDelete) {
        List<Integer> deletedVersions;
        log.info("Deleting subject {}", (Object)subject);
        subject = QualifiedSubject.normalize((String)this.schemaRegistry.tenant(), (String)subject);
        try {
            if (!this.schemaRegistry.hasSubjects(subject, true)) {
                throw Errors.subjectNotFoundException(subject);
            }
            if (!permanentDelete && !this.schemaRegistry.hasSubjects(subject, false)) {
                throw Errors.subjectSoftDeletedException(subject);
            }
            Map<String, String> headerProperties = this.requestHeaderBuilder.buildRequestHeaders(headers, this.schemaRegistry.config().whitelistHeaders());
            deletedVersions = this.schemaRegistry.deleteSubjectOrForward(headerProperties, subject, permanentDelete);
        }
        catch (ReferenceExistsException e) {
            throw Errors.referenceExistsException(e.getMessage());
        }
        catch (SubjectNotSoftDeletedException e) {
            throw Errors.subjectNotSoftDeletedException(subject);
        }
        catch (OperationNotPermittedException e) {
            throw Errors.operationNotPermittedException(e.getMessage());
        }
        catch (SchemaRegistryTimeoutException e) {
            throw Errors.operationTimeoutException("Delete subject operation timed out", e);
        }
        catch (SchemaRegistryException e) {
            throw Errors.schemaRegistryException("Error while deleting the subject " + subject, e);
        }
        asyncResponse.resume(deletedVersions);
    }
}

