/*
 * Decompiled with CFR 0.152.
 */
package io.confluent.kafka.serializers;

import io.confluent.kafka.schemaregistry.client.SchemaRegistryClientConfig;
import io.confluent.kafka.serializers.context.NullContextNameStrategy;
import io.confluent.kafka.serializers.context.strategy.ContextNameStrategy;
import io.confluent.kafka.serializers.subject.SubjectNameStrategy;
import io.confluent.kafka.serializers.subject.TopicNameStrategy;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.stream.Collectors;
import org.apache.kafka.common.config.AbstractConfig;
import org.apache.kafka.common.config.ConfigDef;

public class AbstractKafkaSchemaSerDeConfig
extends AbstractConfig {
    public static final String REQUEST_HEADER_PREFIX = "request.header.";
    public static final String SCHEMA_REGISTRY_URL_CONFIG = "schema.registry.url";
    public static final String SCHEMA_REGISTRY_URL_DOC = "Comma-separated list of URLs for schema registry instances that can be used to register or look up schemas. If you wish to get a connection to a mocked schema registry for testing, you can specify a scope using the 'mock://' pseudo-protocol. For example, 'mock://my-scope-name' corresponds to 'MockSchemaRegistry.getClientForScope(\"my-scope-name\")'.";
    public static final String MAX_SCHEMAS_PER_SUBJECT_CONFIG = "max.schemas.per.subject";
    public static final int MAX_SCHEMAS_PER_SUBJECT_DEFAULT = 1000;
    public static final String MAX_SCHEMAS_PER_SUBJECT_DOC = "Maximum number of schemas to create or cache locally.";
    public static final String AUTO_REGISTER_SCHEMAS = "auto.register.schemas";
    public static final boolean AUTO_REGISTER_SCHEMAS_DEFAULT = true;
    public static final String AUTO_REGISTER_SCHEMAS_DOC = "Specify if the Serializer should attempt to register the Schema with Schema Registry";
    public static final String USE_LATEST_VERSION = "use.latest.version";
    public static final boolean USE_LATEST_VERSION_DEFAULT = false;
    public static final String USE_LATEST_VERSION_DOC = "Specify if the Serializer should use the latest subject version for serialization";
    public static final String LATEST_COMPATIBILITY_STRICT = "latest.compatibility.strict";
    public static final boolean LATEST_COMPATIBILITY_STRICT_DEFAULT = true;
    public static final String LATEST_COMPATIBILITY_STRICT_DOC = "Whether to check for backward compatibility between the latest subject version and  the Schema of the object to be serialized";
    public static final String BASIC_AUTH_CREDENTIALS_SOURCE = "basic.auth.credentials.source";
    public static final String BASIC_AUTH_CREDENTIALS_SOURCE_DEFAULT = "URL";
    public static final String BASIC_AUTH_CREDENTIALS_SOURCE_DOC = "Specify how to pick the credentials for Basic Auth header. The supported values are URL, USER_INFO and SASL_INHERIT";
    public static final String BEARER_AUTH_CREDENTIALS_SOURCE = "bearer.auth.credentials.source";
    public static final String BEARER_AUTH_CREDENTIALS_SOURCE_DEFAULT = "STATIC_TOKEN";
    public static final String BEARER_AUTH_CREDENTIALS_SOURCE_DOC = "Specify how to pick the credentials for Bearer Auth header. ";
    @Deprecated
    public static final String SCHEMA_REGISTRY_USER_INFO_CONFIG = "schema.registry.basic.auth.user.info";
    public static final String SCHEMA_REGISTRY_USER_INFO_DEFAULT = "";
    public static final String SCHEMA_REGISTRY_USER_INFO_DOC = "Specify the user info for Basic Auth in the form of {username}:{password}";
    public static final String USER_INFO_CONFIG = "basic.auth.user.info";
    public static final String USER_INFO_DEFAULT = "";
    public static final String BEARER_AUTH_TOKEN_CONFIG = "bearer.auth.token";
    public static final String BEARER_AUTH_TOKEN_DEFAULT = "";
    public static final String BEARER_AUTH_TOKEN_DOC = "Specify the Bearer token to be used for authentication";
    public static final String CONTEXT_NAME_STRATEGY = "context.name.strategy";
    public static final String CONTEXT_NAME_STRATEGY_DEFAULT = NullContextNameStrategy.class.getName();
    public static final String CONTEXT_NAME_STRATEGY_DOC = "A class used to determine the schema registry context.";
    public static final String KEY_SUBJECT_NAME_STRATEGY = "key.subject.name.strategy";
    public static final String KEY_SUBJECT_NAME_STRATEGY_DEFAULT = TopicNameStrategy.class.getName();
    public static final String KEY_SUBJECT_NAME_STRATEGY_DOC = "Determines how to construct the subject name under which the key schema is registered with the schema registry. By default, <topic>-key is used as subject.";
    public static final String VALUE_SUBJECT_NAME_STRATEGY = "value.subject.name.strategy";
    public static final String VALUE_SUBJECT_NAME_STRATEGY_DEFAULT = TopicNameStrategy.class.getName();
    public static final String VALUE_SUBJECT_NAME_STRATEGY_DOC = "Determines how to construct the subject name under which the value schema is registered with the schema registry. By default, <topic>-value is used as subject.";
    public static final String SCHEMA_REFLECTION_CONFIG = "schema.reflection";
    public static final boolean SCHEMA_REFLECTION_DEFAULT = false;
    public static final String SCHEMA_REFLECTION_DOC = "If true, uses the reflection API when serializing/deserializing ";
    public static final String PROXY_HOST = "proxy.host";
    public static final String PROXY_HOST_DEFAULT = "";
    public static final String PROXY_HOST_DOC = "The hostname, or address, of the proxy server that will be used to connect to the schema registry instances.";
    public static final String PROXY_PORT = "proxy.port";
    public static final int PROXY_PORT_DEFAULT = -1;
    public static final String PROXY_PORT_DOC = "The port number of the proxy server that will be used to connect to the schema registry instances.";

    public static ConfigDef baseConfigDef() {
        ConfigDef configDef = new ConfigDef().define(SCHEMA_REGISTRY_URL_CONFIG, ConfigDef.Type.LIST, ConfigDef.Importance.HIGH, SCHEMA_REGISTRY_URL_DOC).define(MAX_SCHEMAS_PER_SUBJECT_CONFIG, ConfigDef.Type.INT, (Object)1000, ConfigDef.Importance.LOW, MAX_SCHEMAS_PER_SUBJECT_DOC).define(AUTO_REGISTER_SCHEMAS, ConfigDef.Type.BOOLEAN, (Object)true, ConfigDef.Importance.MEDIUM, AUTO_REGISTER_SCHEMAS_DOC).define(USE_LATEST_VERSION, ConfigDef.Type.BOOLEAN, (Object)false, ConfigDef.Importance.LOW, USE_LATEST_VERSION_DOC).define(LATEST_COMPATIBILITY_STRICT, ConfigDef.Type.BOOLEAN, (Object)true, ConfigDef.Importance.LOW, LATEST_COMPATIBILITY_STRICT_DOC).define(BASIC_AUTH_CREDENTIALS_SOURCE, ConfigDef.Type.STRING, (Object)BASIC_AUTH_CREDENTIALS_SOURCE_DEFAULT, ConfigDef.Importance.MEDIUM, BASIC_AUTH_CREDENTIALS_SOURCE_DOC).define(BEARER_AUTH_CREDENTIALS_SOURCE, ConfigDef.Type.STRING, (Object)BEARER_AUTH_CREDENTIALS_SOURCE_DEFAULT, ConfigDef.Importance.MEDIUM, BEARER_AUTH_CREDENTIALS_SOURCE_DOC).define(SCHEMA_REGISTRY_USER_INFO_CONFIG, ConfigDef.Type.PASSWORD, (Object)"", ConfigDef.Importance.MEDIUM, SCHEMA_REGISTRY_USER_INFO_DOC).define(USER_INFO_CONFIG, ConfigDef.Type.PASSWORD, (Object)"", ConfigDef.Importance.MEDIUM, SCHEMA_REGISTRY_USER_INFO_DOC).define(BEARER_AUTH_TOKEN_CONFIG, ConfigDef.Type.PASSWORD, (Object)"", ConfigDef.Importance.MEDIUM, BEARER_AUTH_TOKEN_DOC).define(CONTEXT_NAME_STRATEGY, ConfigDef.Type.CLASS, (Object)CONTEXT_NAME_STRATEGY_DEFAULT, ConfigDef.Importance.MEDIUM, CONTEXT_NAME_STRATEGY_DOC).define(KEY_SUBJECT_NAME_STRATEGY, ConfigDef.Type.CLASS, (Object)KEY_SUBJECT_NAME_STRATEGY_DEFAULT, ConfigDef.Importance.MEDIUM, KEY_SUBJECT_NAME_STRATEGY_DOC).define(VALUE_SUBJECT_NAME_STRATEGY, ConfigDef.Type.CLASS, (Object)VALUE_SUBJECT_NAME_STRATEGY_DEFAULT, ConfigDef.Importance.MEDIUM, VALUE_SUBJECT_NAME_STRATEGY_DOC).define(SCHEMA_REFLECTION_CONFIG, ConfigDef.Type.BOOLEAN, (Object)false, ConfigDef.Importance.LOW, SCHEMA_REFLECTION_DOC).define(PROXY_HOST, ConfigDef.Type.STRING, (Object)"", ConfigDef.Importance.LOW, PROXY_HOST_DOC).define(PROXY_PORT, ConfigDef.Type.INT, (Object)-1, ConfigDef.Importance.LOW, PROXY_PORT_DOC);
        SchemaRegistryClientConfig.withClientSslSupport((ConfigDef)configDef, (String)"schema.registry.");
        return configDef;
    }

    public AbstractKafkaSchemaSerDeConfig(ConfigDef config, Map<?, ?> props) {
        super(config, props);
    }

    public AbstractKafkaSchemaSerDeConfig(ConfigDef definition, Map<?, ?> originals, boolean doLog) {
        super(definition, originals, doLog);
    }

    public int getMaxSchemasPerSubject() {
        return this.getInt(MAX_SCHEMAS_PER_SUBJECT_CONFIG);
    }

    public List<String> getSchemaRegistryUrls() {
        return this.getList(SCHEMA_REGISTRY_URL_CONFIG);
    }

    public boolean autoRegisterSchema() {
        return this.getBoolean(AUTO_REGISTER_SCHEMAS);
    }

    public boolean useLatestVersion() {
        return this.getBoolean(USE_LATEST_VERSION);
    }

    public boolean getLatestCompatibilityStrict() {
        return this.getBoolean(LATEST_COMPATIBILITY_STRICT);
    }

    public ContextNameStrategy contextNameStrategy() {
        return (ContextNameStrategy)this.getConfiguredInstance(CONTEXT_NAME_STRATEGY, ContextNameStrategy.class);
    }

    public Object keySubjectNameStrategy() {
        return this.subjectNameStrategyInstance(KEY_SUBJECT_NAME_STRATEGY);
    }

    public Object valueSubjectNameStrategy() {
        return this.subjectNameStrategyInstance(VALUE_SUBJECT_NAME_STRATEGY);
    }

    public boolean useSchemaReflection() {
        return this.getBoolean(SCHEMA_REFLECTION_CONFIG);
    }

    public Map<String, String> requestHeaders() {
        return this.originalsWithPrefix(REQUEST_HEADER_PREFIX).entrySet().stream().collect(Collectors.toMap(Map.Entry::getKey, entry -> Objects.toString(entry.getValue())));
    }

    private Object subjectNameStrategyInstance(String config) {
        Class<SubjectNameStrategy> deprecatedClass = SubjectNameStrategy.class;
        Class subjectNameStrategyClass = this.getClass(config);
        if (deprecatedClass.isAssignableFrom(subjectNameStrategyClass)) {
            return this.getConfiguredInstance(config, deprecatedClass);
        }
        return this.getConfiguredInstance(config, io.confluent.kafka.serializers.subject.strategy.SubjectNameStrategy.class);
    }

    public String basicAuthUserInfo() {
        String deprecatedValue = this.getString(SCHEMA_REGISTRY_USER_INFO_CONFIG);
        if (deprecatedValue != null && !deprecatedValue.isEmpty()) {
            return deprecatedValue;
        }
        return this.getString(USER_INFO_CONFIG);
    }
}

