/*
 * Decompiled with CFR 0.152.
 */
package io.confluent.kafka.formatter;

import io.confluent.kafka.formatter.SchemaMessageDeserializer;
import io.confluent.kafka.schemaregistry.SchemaProvider;
import io.confluent.kafka.schemaregistry.client.CachedSchemaRegistryClient;
import io.confluent.kafka.schemaregistry.client.SchemaRegistryClient;
import io.confluent.kafka.schemaregistry.testutil.MockSchemaRegistry;
import io.confluent.kafka.serializers.AbstractKafkaSchemaSerDe;
import java.io.IOException;
import java.io.PrintStream;
import java.nio.ByteBuffer;
import java.nio.charset.StandardCharsets;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import org.apache.kafka.clients.consumer.ConsumerRecord;
import org.apache.kafka.common.MessageFormatter;
import org.apache.kafka.common.config.ConfigException;
import org.apache.kafka.common.errors.SerializationException;
import org.apache.kafka.common.record.TimestampType;
import org.apache.kafka.common.serialization.Deserializer;

public abstract class SchemaMessageFormatter<T>
implements MessageFormatter {
    private static final byte[] NULL_BYTES = "null".getBytes(StandardCharsets.UTF_8);
    private boolean printKey = false;
    private boolean printTimestamp = false;
    private boolean printIds = false;
    private boolean printKeyId = false;
    private boolean printValueId = false;
    private byte[] keySeparator = "\t".getBytes(StandardCharsets.UTF_8);
    private byte[] lineSeparator = "\n".getBytes(StandardCharsets.UTF_8);
    private byte[] idSeparator = "\t".getBytes(StandardCharsets.UTF_8);
    protected SchemaMessageDeserializer<T> deserializer;
    private static final int MAGIC_BYTE = 0;

    public SchemaMessageFormatter() {
    }

    public SchemaMessageFormatter(SchemaRegistryClient schemaRegistryClient, Deserializer keyDeserializer) {
        this.deserializer = this.createDeserializer(schemaRegistryClient, keyDeserializer);
    }

    protected abstract SchemaMessageDeserializer<T> createDeserializer(SchemaRegistryClient var1, Deserializer var2);

    public void configure(Map<String, ?> configs) {
        Properties properties = new Properties();
        properties.putAll(configs);
        this.init(properties);
    }

    public void init(Properties props) {
        if (props == null) {
            throw new ConfigException("Missing schema registry url!");
        }
        String url = props.getProperty("schema.registry.url");
        if (url == null) {
            throw new ConfigException("Missing schema registry url!");
        }
        if (props.containsKey("print.timestamp")) {
            this.printTimestamp = props.getProperty("print.timestamp").trim().toLowerCase().equals("true");
        }
        if (props.containsKey("print.key")) {
            this.printKey = props.getProperty("print.key").trim().toLowerCase().equals("true");
        }
        if (props.containsKey("key.separator")) {
            this.keySeparator = props.getProperty("key.separator").getBytes(StandardCharsets.UTF_8);
        }
        if (props.containsKey("line.separator")) {
            this.lineSeparator = props.getProperty("line.separator").getBytes(StandardCharsets.UTF_8);
        }
        Deserializer keyDeserializer = null;
        if (props.containsKey("key.deserializer")) {
            try {
                keyDeserializer = (Deserializer)Class.forName((String)props.get("key.deserializer")).newInstance();
            }
            catch (Exception e) {
                throw new ConfigException("Error initializing Key deserializer: " + e.getMessage());
            }
        }
        if (props.containsKey("print.schema.ids")) {
            this.printIds = props.getProperty("print.schema.ids").trim().toLowerCase().equals("true");
            if (this.printIds) {
                this.printValueId = true;
                if (keyDeserializer == null || keyDeserializer instanceof AbstractKafkaSchemaSerDe) {
                    this.printKeyId = true;
                }
            }
        }
        if (props.containsKey("schema.id.separator")) {
            this.idSeparator = props.getProperty("schema.id.separator").getBytes(StandardCharsets.UTF_8);
        }
        if (this.deserializer == null) {
            Map<String, Object> originals = this.getPropertiesMap(props);
            SchemaRegistryClient schemaRegistry = this.createSchemaRegistry(url, originals);
            this.deserializer = this.createDeserializer(schemaRegistry, keyDeserializer);
        }
    }

    private Map<String, Object> getPropertiesMap(Properties props) {
        HashMap<String, Object> originals = new HashMap<String, Object>();
        for (String name : props.stringPropertyNames()) {
            originals.put(name, props.getProperty(name));
        }
        return originals;
    }

    public void writeTo(ConsumerRecord<byte[], byte[]> consumerRecord, PrintStream output) {
        if (this.printTimestamp) {
            try {
                TimestampType timestampType = consumerRecord.timestampType();
                if (timestampType != TimestampType.NO_TIMESTAMP_TYPE) {
                    output.write(String.format("%s:%d", timestampType, consumerRecord.timestamp()).getBytes(StandardCharsets.UTF_8));
                } else {
                    output.write("NO_TIMESTAMP".getBytes(StandardCharsets.UTF_8));
                }
                output.write(this.keySeparator);
            }
            catch (IOException ioe) {
                throw new SerializationException("Error while formatting the timestamp", (Throwable)ioe);
            }
        }
        if (this.printKey) {
            try {
                if (this.deserializer.getKeyDeserializer() != null) {
                    Object deserializedKey = consumerRecord.key() == null ? null : this.deserializer.deserializeKey(consumerRecord.topic(), (byte[])consumerRecord.key());
                    output.write(deserializedKey != null ? deserializedKey.toString().getBytes(StandardCharsets.UTF_8) : NULL_BYTES);
                } else {
                    this.writeTo(consumerRecord.topic(), (byte[])consumerRecord.key(), output);
                }
                if (this.printKeyId) {
                    output.write(this.idSeparator);
                    if (consumerRecord.key() != null) {
                        int schemaId = this.schemaIdFor((byte[])consumerRecord.key());
                        output.print(schemaId);
                    } else {
                        output.write(NULL_BYTES);
                    }
                }
                output.write(this.keySeparator);
            }
            catch (IOException ioe) {
                throw new SerializationException("Error while formatting the key", (Throwable)ioe);
            }
        }
        try {
            this.writeTo(consumerRecord.topic(), (byte[])consumerRecord.value(), output);
            if (this.printValueId) {
                output.write(this.idSeparator);
                int schemaId = this.schemaIdFor((byte[])consumerRecord.value());
                output.print(schemaId);
            }
            output.write(this.lineSeparator);
        }
        catch (IOException ioe) {
            throw new SerializationException("Error while formatting the value", (Throwable)ioe);
        }
    }

    protected abstract void writeTo(String var1, byte[] var2, PrintStream var3) throws IOException;

    public void close() {
        if (this.deserializer != null) {
            try {
                this.deserializer.close();
            }
            catch (IOException e) {
                throw new RuntimeException("Exception while closing deserializer", e);
            }
        }
    }

    private int schemaIdFor(byte[] payload) {
        ByteBuffer buffer = ByteBuffer.wrap(payload);
        if (buffer.get() != 0) {
            throw new SerializationException("Unknown magic byte!");
        }
        return buffer.getInt();
    }

    private SchemaRegistryClient createSchemaRegistry(String schemaRegistryUrl, Map<String, Object> originals) {
        String maybeMockScope = MockSchemaRegistry.validateAndMaybeGetMockScope(Collections.singletonList(schemaRegistryUrl));
        List<SchemaProvider> providers = Collections.singletonList(this.getProvider());
        if (maybeMockScope == null) {
            return new CachedSchemaRegistryClient(schemaRegistryUrl, 1000, providers, originals);
        }
        return MockSchemaRegistry.getClientForScope((String)maybeMockScope, providers);
    }

    protected abstract SchemaProvider getProvider();
}

