/*
 * Decompiled with CFR 0.152.
 */
package io.confluent.kafka.streams.serdes.avro;

import io.confluent.kafka.schemaregistry.client.SchemaRegistryClient;
import io.confluent.kafka.streams.serdes.avro.GenericAvroDeserializer;
import io.confluent.kafka.streams.serdes.avro.GenericAvroSerializer;
import java.util.Map;
import org.apache.avro.generic.GenericRecord;
import org.apache.kafka.common.annotation.InterfaceStability;
import org.apache.kafka.common.serialization.Deserializer;
import org.apache.kafka.common.serialization.Serde;
import org.apache.kafka.common.serialization.Serdes;
import org.apache.kafka.common.serialization.Serializer;

@InterfaceStability.Unstable
public class GenericAvroSerde
implements Serde<GenericRecord> {
    private final Serde<GenericRecord> inner;

    public GenericAvroSerde() {
        this.inner = Serdes.serdeFrom((Serializer)new GenericAvroSerializer(), (Deserializer)new GenericAvroDeserializer());
    }

    GenericAvroSerde(SchemaRegistryClient client) {
        if (client == null) {
            throw new IllegalArgumentException("schema registry client must not be null");
        }
        this.inner = Serdes.serdeFrom((Serializer)new GenericAvroSerializer(client), (Deserializer)new GenericAvroDeserializer(client));
    }

    public Serializer<GenericRecord> serializer() {
        return this.inner.serializer();
    }

    public Deserializer<GenericRecord> deserializer() {
        return this.inner.deserializer();
    }

    public void configure(Map<String, ?> serdeConfig, boolean isSerdeForRecordKeys) {
        this.inner.serializer().configure(serdeConfig, isSerdeForRecordKeys);
        this.inner.deserializer().configure(serdeConfig, isSerdeForRecordKeys);
    }

    public void close() {
        this.inner.serializer().close();
        this.inner.deserializer().close();
    }
}

