/*
 * Decompiled with CFR 0.152.
 */
package io.confluent.ksql.api.client.impl;

import io.confluent.ksql.api.client.ExecuteStatementResult;
import io.confluent.ksql.api.client.exception.KsqlClientException;
import io.confluent.ksql.api.client.impl.AdminResponseHandlers;
import io.confluent.ksql.api.client.impl.ExecuteStatementResultImpl;
import io.vertx.core.json.JsonObject;
import java.util.Optional;
import java.util.concurrent.CompletableFuture;

final class DdlDmlResponseHandlers {
    public static final String EXECUTE_STATEMENT_REQUEST_ACCEPTED_DOC = "The ksqlDB server accepted the statement issued via executeStatement(), but the response received is of an unexpected format. ";
    public static final String EXECUTE_STATEMENT_USAGE_DOC = "The executeStatement() method is only for 'CREATE', 'CREATE ... AS SELECT', 'DROP', 'TERMINATE', and 'INSERT INTO ... AS SELECT' statements. ";

    private DdlDmlResponseHandlers() {
    }

    static void handleExecuteStatementResponse(JsonObject ksqlEntity, CompletableFuture<ExecuteStatementResult> cf) {
        if (!DdlDmlResponseHandlers.isCommandStatusEntity(ksqlEntity)) {
            DdlDmlResponseHandlers.handleUnexpectedEntity(ksqlEntity, cf);
            return;
        }
        try {
            Optional<String> queryId = Optional.ofNullable(ksqlEntity.getJsonObject("commandStatus").getString("queryId"));
            cf.complete(new ExecuteStatementResultImpl(queryId));
        }
        catch (Exception e) {
            cf.completeExceptionally(new IllegalStateException("Unexpected server response format. Response: " + ksqlEntity));
        }
    }

    static RuntimeException handleUnexpectedNumResponseEntities(int numEntities) {
        if (numEntities == 0) {
            return new KsqlClientException("The ksqlDB server accepted the statement issued via executeStatement(), but the response received is of an unexpected format. The executeStatement() method is only for 'CREATE', 'CREATE ... AS SELECT', 'DROP', 'TERMINATE', and 'INSERT INTO ... AS SELECT' statements. ");
        }
        throw new IllegalStateException("Unexpected number of entities in server response: " + numEntities);
    }

    private static boolean isCommandStatusEntity(JsonObject ksqlEntity) {
        return ksqlEntity.getString("commandId") != null && ksqlEntity.getJsonObject("commandStatus") != null;
    }

    private static void handleUnexpectedEntity(JsonObject ksqlEntity, CompletableFuture<ExecuteStatementResult> cf) {
        if (AdminResponseHandlers.isListStreamsResponse(ksqlEntity)) {
            cf.completeExceptionally(new KsqlClientException("The executeStatement() method is only for 'CREATE', 'CREATE ... AS SELECT', 'DROP', 'TERMINATE', and 'INSERT INTO ... AS SELECT' statements. Use the listStreams() method instead."));
        } else if (AdminResponseHandlers.isListTablesResponse(ksqlEntity)) {
            cf.completeExceptionally(new KsqlClientException("The executeStatement() method is only for 'CREATE', 'CREATE ... AS SELECT', 'DROP', 'TERMINATE', and 'INSERT INTO ... AS SELECT' statements. Use the listTables() method instead."));
        } else if (AdminResponseHandlers.isListTopicsResponse(ksqlEntity)) {
            cf.completeExceptionally(new KsqlClientException("The executeStatement() method is only for 'CREATE', 'CREATE ... AS SELECT', 'DROP', 'TERMINATE', and 'INSERT INTO ... AS SELECT' statements. Use the listTopics() method instead."));
        } else if (AdminResponseHandlers.isListQueriesResponse(ksqlEntity)) {
            cf.completeExceptionally(new KsqlClientException("The executeStatement() method is only for 'CREATE', 'CREATE ... AS SELECT', 'DROP', 'TERMINATE', and 'INSERT INTO ... AS SELECT' statements. Use the listQueries() method instead."));
        } else if (AdminResponseHandlers.isDescribeSourceResponse(ksqlEntity)) {
            cf.completeExceptionally(new KsqlClientException("The executeStatement() method is only for 'CREATE', 'CREATE ... AS SELECT', 'DROP', 'TERMINATE', and 'INSERT INTO ... AS SELECT' statements. The client does not currently support 'DESCRIBE <STREAM/TABLE>' statements."));
        } else if (AdminResponseHandlers.isDescribeOrListFunctionResponse(ksqlEntity)) {
            cf.completeExceptionally(new KsqlClientException("The executeStatement() method is only for 'CREATE', 'CREATE ... AS SELECT', 'DROP', 'TERMINATE', and 'INSERT INTO ... AS SELECT' statements. The client does not currently support 'DESCRIBE <FUNCTION>' statements or listing functions."));
        } else if (AdminResponseHandlers.isExplainQueryResponse(ksqlEntity)) {
            cf.completeExceptionally(new KsqlClientException("The executeStatement() method is only for 'CREATE', 'CREATE ... AS SELECT', 'DROP', 'TERMINATE', and 'INSERT INTO ... AS SELECT' statements. The client does not currently support 'EXPLAIN <QUERY_ID>' statements."));
        } else if (AdminResponseHandlers.isListPropertiesResponse(ksqlEntity)) {
            cf.completeExceptionally(new KsqlClientException("The executeStatement() method is only for 'CREATE', 'CREATE ... AS SELECT', 'DROP', 'TERMINATE', and 'INSERT INTO ... AS SELECT' statements. The client does not currently support listing properties."));
        } else if (AdminResponseHandlers.isListTypesResponse(ksqlEntity)) {
            cf.completeExceptionally(new KsqlClientException("The executeStatement() method is only for 'CREATE', 'CREATE ... AS SELECT', 'DROP', 'TERMINATE', and 'INSERT INTO ... AS SELECT' statements. The client does not currently support listing custom types."));
        } else if (AdminResponseHandlers.isListConnectorsResponse(ksqlEntity)) {
            cf.completeExceptionally(new KsqlClientException("The executeStatement() method is only for 'CREATE', 'CREATE ... AS SELECT', 'DROP', 'TERMINATE', and 'INSERT INTO ... AS SELECT' statements. The client does not currently support listing connectors."));
        } else if (AdminResponseHandlers.isDescribeConnectorResponse(ksqlEntity)) {
            cf.completeExceptionally(new KsqlClientException("The executeStatement() method is only for 'CREATE', 'CREATE ... AS SELECT', 'DROP', 'TERMINATE', and 'INSERT INTO ... AS SELECT' statements. The client does not currently support 'DESCRIBE <CONNECTOR>' statements."));
        } else if (AdminResponseHandlers.isCreateConnectorResponse(ksqlEntity)) {
            cf.completeExceptionally(new KsqlClientException("The ksqlDB server accepted the statement issued via executeStatement(), but the response received is of an unexpected format. The executeStatement() method is only for 'CREATE', 'CREATE ... AS SELECT', 'DROP', 'TERMINATE', and 'INSERT INTO ... AS SELECT' statements. The client does not currently support 'CREATE CONNECTOR' statements."));
        } else if (AdminResponseHandlers.isDropConnectorResponse(ksqlEntity)) {
            cf.completeExceptionally(new KsqlClientException("The ksqlDB server accepted the statement issued via executeStatement(), but the response received is of an unexpected format. The executeStatement() method is only for 'CREATE', 'CREATE ... AS SELECT', 'DROP', 'TERMINATE', and 'INSERT INTO ... AS SELECT' statements. The client does not currently support 'DROP CONNECTOR' statements."));
        } else if (AdminResponseHandlers.isConnectErrorResponse(ksqlEntity)) {
            cf.completeExceptionally(new KsqlClientException("The executeStatement() method is only for 'CREATE', 'CREATE ... AS SELECT', 'DROP', 'TERMINATE', and 'INSERT INTO ... AS SELECT' statements. The client does not currently support statements for creating, dropping, listing, or describing connectors."));
        } else {
            cf.completeExceptionally(new IllegalStateException("Unexpected server response type. Response: " + ksqlEntity));
        }
    }
}

