/*
 * Decompiled with CFR 0.152.
 */
package io.confluent.ksql.api.client.impl;

import com.fasterxml.jackson.databind.ObjectMapper;
import io.confluent.ksql.api.client.impl.ResponseHandler;
import io.confluent.ksql.api.client.util.JsonMapper;
import io.confluent.ksql.rest.entity.QueryResponseMetadata;
import io.vertx.core.Context;
import io.vertx.core.buffer.Buffer;
import io.vertx.core.parsetools.RecordParser;
import java.util.concurrent.CompletableFuture;

abstract class QueryResponseHandler<T extends CompletableFuture<?>>
extends ResponseHandler<T> {
    private static ObjectMapper JSON_MAPPER = JsonMapper.get();
    protected boolean hasReadArguments;

    QueryResponseHandler(Context context, RecordParser recordParser, T cf) {
        super(context, recordParser, cf);
    }

    @Override
    protected void doHandleBodyBuffer(Buffer buff) {
        if (!this.hasReadArguments) {
            this.handleArgs(buff);
        } else {
            this.handleRow(buff);
        }
    }

    @Override
    protected void doHandleException(Throwable t) {
        if (!this.cf.isDone()) {
            this.cf.completeExceptionally(t);
        } else {
            this.handleExceptionAfterFutureCompleted(t);
        }
    }

    protected abstract void handleMetadata(QueryResponseMetadata var1);

    protected abstract void handleRow(Buffer var1);

    protected abstract void handleExceptionAfterFutureCompleted(Throwable var1);

    private void handleArgs(Buffer buff) {
        QueryResponseMetadata queryResponseMetadata;
        this.hasReadArguments = true;
        try {
            queryResponseMetadata = (QueryResponseMetadata)JSON_MAPPER.readValue(buff.getBytes(), QueryResponseMetadata.class);
        }
        catch (Exception e) {
            this.cf.completeExceptionally(e);
            return;
        }
        this.handleMetadata(queryResponseMetadata);
    }
}

