/*
 * Decompiled with CFR 0.152.
 */
package io.confluent.ksql.function;

import com.google.common.collect.ImmutableList;
import io.confluent.ksql.function.AggregateFunctionInitArguments;
import io.confluent.ksql.function.KsqlAggregateFunction;
import io.confluent.ksql.function.types.DecimalType;
import io.confluent.ksql.function.types.ParamType;
import io.confluent.ksql.function.types.ParamTypes;
import io.confluent.ksql.function.udf.UdfMetadata;
import io.confluent.ksql.schema.ksql.SchemaConverters;
import io.confluent.ksql.schema.ksql.types.SqlDecimal;
import io.confluent.ksql.schema.ksql.types.SqlType;
import java.util.List;
import java.util.Objects;
import java.util.function.Consumer;
import java.util.stream.Collectors;

public abstract class AggregateFunctionFactory {
    private final UdfMetadata metadata;
    protected static final List<List<ParamType>> NUMERICAL_ARGS = ImmutableList.builder().add((Object)ImmutableList.of((Object)ParamTypes.INTEGER)).add((Object)ImmutableList.of((Object)ParamTypes.LONG)).add((Object)ImmutableList.of((Object)ParamTypes.DOUBLE)).add((Object)ImmutableList.of((Object)ParamTypes.DECIMAL)).build();

    public AggregateFunctionFactory(String functionName) {
        this(new UdfMetadata(functionName, "", "Confluent", "", "AGGREGATE", "internal"));
    }

    public AggregateFunctionFactory(UdfMetadata metadata) {
        this.metadata = Objects.requireNonNull(metadata, "metadata can't be null");
    }

    public abstract KsqlAggregateFunction<?, ?, ?> createAggregateFunction(List<SqlType> var1, AggregateFunctionInitArguments var2);

    protected abstract List<List<ParamType>> supportedArgs();

    public UdfMetadata getMetadata() {
        return this.metadata;
    }

    public String getName() {
        return this.metadata.getName();
    }

    public void eachFunction(Consumer<KsqlAggregateFunction<?, ?, ?>> consumer) {
        this.supportedArgs().stream().map(args -> args.stream().map(AggregateFunctionFactory::getSampleSqlType).collect(Collectors.toList())).forEach(args -> consumer.accept(this.createAggregateFunction((List<SqlType>)args, this.getDefaultArguments())));
    }

    private static SqlType getSampleSqlType(ParamType paramType) {
        if (paramType instanceof DecimalType) {
            return SqlDecimal.of((int)2, (int)1);
        }
        return SchemaConverters.functionToSqlConverter().toSqlType(paramType);
    }

    public AggregateFunctionInitArguments getDefaultArguments() {
        return AggregateFunctionInitArguments.EMPTY_ARGS;
    }
}

