/*
 * Decompiled with CFR 0.152.
 */
package io.confluent.ksql.function.types;

import io.confluent.ksql.function.types.ArrayType;
import io.confluent.ksql.function.types.BooleanType;
import io.confluent.ksql.function.types.DecimalType;
import io.confluent.ksql.function.types.DoubleType;
import io.confluent.ksql.function.types.IntegerType;
import io.confluent.ksql.function.types.LongType;
import io.confluent.ksql.function.types.MapType;
import io.confluent.ksql.function.types.ParamType;
import io.confluent.ksql.function.types.StringType;
import io.confluent.ksql.function.types.StructType;
import io.confluent.ksql.schema.ksql.SchemaConverters;
import io.confluent.ksql.schema.ksql.types.Field;
import io.confluent.ksql.schema.ksql.types.SqlArray;
import io.confluent.ksql.schema.ksql.types.SqlBaseType;
import io.confluent.ksql.schema.ksql.types.SqlMap;
import io.confluent.ksql.schema.ksql.types.SqlStruct;
import io.confluent.ksql.schema.ksql.types.SqlType;
import java.util.Map;
import java.util.Optional;

public final class ParamTypes {
    public static final BooleanType BOOLEAN = BooleanType.INSTANCE;
    public static final IntegerType INTEGER = IntegerType.INSTANCE;
    public static final DoubleType DOUBLE = DoubleType.INSTANCE;
    public static final StringType STRING = StringType.INSTANCE;
    public static final LongType LONG = LongType.INSTANCE;
    public static final ParamType DECIMAL = DecimalType.INSTANCE;

    private ParamTypes() {
    }

    public static boolean areCompatible(SqlType actual, ParamType declared) {
        return ParamTypes.areCompatible(actual, declared, false);
    }

    public static boolean areCompatible(SqlType actual, ParamType declared, boolean allowCast) {
        if (actual.baseType() == SqlBaseType.ARRAY && declared instanceof ArrayType) {
            return ParamTypes.areCompatible(((SqlArray)actual).getItemType(), ((ArrayType)declared).element(), allowCast);
        }
        if (actual.baseType() == SqlBaseType.MAP && declared instanceof MapType) {
            SqlMap sqlType = (SqlMap)actual;
            MapType mapType = (MapType)declared;
            return ParamTypes.areCompatible(sqlType.getKeyType(), mapType.key(), allowCast) && ParamTypes.areCompatible(sqlType.getValueType(), mapType.value(), allowCast);
        }
        if (actual.baseType() == SqlBaseType.STRUCT && declared instanceof StructType) {
            return ParamTypes.isStructCompatible(actual, declared);
        }
        return ParamTypes.isPrimitiveMatch(actual, declared, allowCast);
    }

    private static boolean isStructCompatible(SqlType actual, ParamType declared) {
        SqlStruct actualStruct = (SqlStruct)actual;
        if (actualStruct.fields().isEmpty() || ((StructType)declared).getSchema().isEmpty()) {
            return true;
        }
        for (Map.Entry<String, ParamType> entry : ((StructType)declared).getSchema().entrySet()) {
            String k = entry.getKey();
            Optional field = actualStruct.field(k);
            if (field.isPresent() && ParamTypes.areCompatible(((Field)field.get()).type(), entry.getValue())) continue;
            return false;
        }
        return actualStruct.fields().size() == ((StructType)declared).getSchema().size();
    }

    private static boolean isPrimitiveMatch(SqlType actual, ParamType declared, boolean allowCast) {
        SqlBaseType base = actual.baseType();
        return base == SqlBaseType.STRING && declared instanceof StringType || base == SqlBaseType.INTEGER && declared instanceof IntegerType || base == SqlBaseType.BIGINT && declared instanceof LongType || base == SqlBaseType.BOOLEAN && declared instanceof BooleanType || base == SqlBaseType.DOUBLE && declared instanceof DoubleType || base == SqlBaseType.DECIMAL && declared instanceof DecimalType || allowCast && base.canImplicitlyCast(SchemaConverters.functionToSqlBaseConverter().toBaseType(declared));
    }
}

