/*
 * Decompiled with CFR 0.152.
 */
package io.confluent.ksql.name;

import com.fasterxml.jackson.annotation.JsonValue;
import com.google.errorprone.annotations.Immutable;
import io.confluent.ksql.schema.utils.FormatOptions;
import java.util.Objects;

@Immutable
public abstract class Name<T extends Name<?>> {
    protected final String name;

    protected Name(String name) {
        this.name = Objects.requireNonNull(name, "name");
        if (!name.trim().equals(name)) {
            throw new IllegalArgumentException("name is not trimmed: '" + name + "'");
        }
        if (name.isEmpty()) {
            throw new IllegalArgumentException("name is empty");
        }
    }

    @JsonValue
    public String text() {
        return this.name;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        Name that = (Name)o;
        return Objects.equals(this.name, that.name);
    }

    public int hashCode() {
        return Objects.hash(this.getClass(), this.name);
    }

    public String toString() {
        return this.toString(FormatOptions.none());
    }

    public String toString(FormatOptions formatOptions) {
        return formatOptions.escape(this.name);
    }
}

