/*
 * Decompiled with CFR 0.152.
 */
package io.confluent.ksql.properties;

import com.google.common.collect.ImmutableMap;
import com.google.common.collect.ImmutableSet;
import io.confluent.ksql.util.KsqlException;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.util.HashMap;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import java.util.function.Predicate;
import java.util.stream.Collectors;

public final class PropertiesUtil {
    private static final Set<Predicate<String>> BLACK_LIST = ImmutableSet.builder().add(key -> key.startsWith("java.")).add(key -> key.startsWith("os.")).add(key -> key.startsWith("sun.")).add(key -> key.startsWith("user.")).add(key -> key.startsWith("line.separator")).add(key -> key.startsWith("path.separator")).add(key -> key.startsWith("file.separator")).build();
    private static final Predicate<String> IS_BLACKLISTED = BLACK_LIST.stream().reduce(key -> false, Predicate::or);
    private static final Predicate<String> NOT_BLACKLISTED = IS_BLACKLISTED.negate();

    private PropertiesUtil() {
    }

    public static Properties asProperties(Map<String, ?> mapProps) {
        Properties properties = new Properties();
        properties.putAll(mapProps);
        return properties;
    }

    public static Map<String, String> loadProperties(File propertiesFile) {
        Map<String, String> properties = PropertiesUtil.loadPropsFromFile(propertiesFile);
        PropertiesUtil.throwOnBlackListedProperties(properties);
        return properties;
    }

    public static Map<String, String> applyOverrides(Map<String, String> props, Properties overrides) {
        Map<String, String> overridesMap = PropertiesUtil.asMap(overrides);
        HashMap<String, String> merged = new HashMap<String, String>(props);
        merged.putAll(PropertiesUtil.filterByKey(overridesMap, NOT_BLACKLISTED));
        return ImmutableMap.copyOf(merged);
    }

    public static Map<String, String> filterByKey(Map<String, String> props, Predicate<String> predicate) {
        ImmutableMap.Builder builder = ImmutableMap.builder();
        props.entrySet().stream().filter(e -> predicate.test((String)e.getKey())).forEach(e -> builder.put(e.getKey(), e.getValue()));
        return builder.build();
    }

    private static Map<String, String> loadPropsFromFile(File propertiesFile) {
        Properties properties = new Properties();
        try (FileInputStream inputStream = new FileInputStream(propertiesFile);){
            properties.load(inputStream);
        }
        catch (IOException e) {
            throw new KsqlException("Failed to load properties file: " + propertiesFile);
        }
        return PropertiesUtil.asMap(properties);
    }

    private static void throwOnBlackListedProperties(Map<String, ?> properties) {
        String separator = System.lineSeparator() + "\t- ";
        String blacklisted = properties.keySet().stream().filter(IS_BLACKLISTED).collect(Collectors.joining(separator));
        if (!blacklisted.isEmpty()) {
            throw new KsqlException("Property file contains the following blacklisted properties (Please remove them an try again):" + separator + blacklisted);
        }
    }

    private static Map<String, String> asMap(Properties props) {
        ImmutableMap.Builder builder = ImmutableMap.builder();
        props.stringPropertyNames().forEach(key -> builder.put(key, (Object)props.getProperty((String)key)));
        return builder.build();
    }
}

