/*
 * Decompiled with CFR 0.152.
 */
package io.confluent.ksql.function;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.Iterables;
import com.google.errorprone.annotations.Immutable;
import io.confluent.ksql.function.FunctionSignature;
import io.confluent.ksql.function.ParameterInfo;
import io.confluent.ksql.function.SchemaProvider;
import io.confluent.ksql.function.types.ArrayType;
import io.confluent.ksql.function.types.ParamType;
import io.confluent.ksql.name.FunctionName;
import io.confluent.ksql.schema.ksql.SqlArgument;
import io.confluent.ksql.schema.ksql.types.SqlType;
import io.confluent.ksql.testing.EffectivelyImmutable;
import java.util.Collection;
import java.util.List;
import java.util.Objects;
import java.util.stream.Collectors;

@Immutable
public class KsqlFunction
implements FunctionSignature {
    @EffectivelyImmutable
    private final SchemaProvider returnSchemaProvider;
    private final ParamType declaredReturnType;
    private final ImmutableList<ParameterInfo> parameters;
    private final ImmutableList<ParamType> paramTypes;
    private final FunctionName functionName;
    private final String description;
    private final String pathLoadedFrom;
    private final boolean isVariadic;

    KsqlFunction(SchemaProvider returnSchemaProvider, ParamType declaredReturnType, List<ParameterInfo> parameters, FunctionName functionName, String description, String pathLoadedFrom, boolean isVariadic) {
        this.returnSchemaProvider = Objects.requireNonNull(returnSchemaProvider, "schemaProvider");
        this.declaredReturnType = Objects.requireNonNull(declaredReturnType, "javaReturnType");
        this.parameters = ImmutableList.copyOf((Collection)Objects.requireNonNull(parameters, "parameters"));
        this.paramTypes = ImmutableList.copyOf((Collection)parameters.stream().map(ParameterInfo::type).collect(Collectors.toList()));
        this.functionName = Objects.requireNonNull(functionName, "functionName");
        this.description = Objects.requireNonNull(description, "description");
        this.pathLoadedFrom = Objects.requireNonNull(pathLoadedFrom, "pathLoadedFrom");
        this.isVariadic = isVariadic;
        if (parameters.stream().anyMatch(Objects::isNull)) {
            throw new IllegalArgumentException("KSQL Function can't have null argument types");
        }
        if (isVariadic) {
            if (parameters.isEmpty()) {
                throw new IllegalArgumentException("KSQL variadic functions must have at least one parameter");
            }
            if (!(((ParameterInfo)Iterables.getLast(parameters)).type() instanceof ArrayType)) {
                throw new IllegalArgumentException("KSQL variadic functions must have ARRAY type as their last parameter");
            }
        }
    }

    public SqlType getReturnType(List<SqlArgument> arguments) {
        return this.returnSchemaProvider.resolve(this.parameters(), arguments);
    }

    @Override
    public ParamType declaredReturnType() {
        return this.declaredReturnType;
    }

    @Override
    public List<ParamType> parameters() {
        return this.paramTypes;
    }

    @Override
    public List<ParameterInfo> parameterInfo() {
        return this.parameters;
    }

    @Override
    public FunctionName name() {
        return this.functionName;
    }

    public String getDescription() {
        return this.description;
    }

    public String getPathLoadedFrom() {
        return this.pathLoadedFrom;
    }

    @Override
    public boolean isVariadic() {
        return this.isVariadic;
    }

    public String toString() {
        return "KsqlFunction{returnType=" + this.declaredReturnType + ", arguments=" + this.parameters + ", functionName='" + this.functionName + '\'' + ", description='" + this.description + "', pathLoadedFrom='" + this.pathLoadedFrom + "', isVariadic=" + this.isVariadic + '}';
    }
}

