/*
 * Decompiled with CFR 0.152.
 */
package io.confluent.ksql.logging.processing;

import java.util.Map;
import java.util.Set;
import org.apache.kafka.common.config.AbstractConfig;
import org.apache.kafka.common.config.ConfigDef;

public class ProcessingLogConfig
extends AbstractConfig {
    private static final String PROPERTY_PREFIX = "logging.processing.";
    public static final String STREAM_NAME = ProcessingLogConfig.propertyName("stream.name");
    private static final String STREAM_NAME_DEFAULT = "KSQL_PROCESSING_LOG";
    private static final String STREAM_NAME_DOC = "If automatic processing log stream creation is enabled, KSQL sets the name of the stream to the value of this property.";
    public static final String TOPIC_NAME = ProcessingLogConfig.propertyName("topic.name");
    public static final String TOPIC_NAME_NOT_SET = "";
    public static final String TOPIC_NAME_DEFAULT_SUFFIX = "ksql_processing_log";
    private static final String TOPIC_NAME_DOC = "If automatic processing log topic creation is enabled, KSQL sets the name of the topic to the value of this property. If automatic processing log stream creation is enabled, KSQL uses this topic to back the stream.";
    public static final String TOPIC_PARTITIONS = ProcessingLogConfig.propertyName("topic.partitions");
    private static final int TOPIC_PARTITIONS_DEFAULT = 1;
    private static final String TOPIC_PARTITIONS_DOC = "If automatic processing log topic creation is enabled, KSQL creates the topic with number of partitions set to the value of this property.";
    public static final String TOPIC_REPLICATION_FACTOR = ProcessingLogConfig.propertyName("topic.replication.factor");
    private static final short TOPIC_REPLICATION_FACTOR_DEFAULT = 1;
    private static final String TOPIC_REPLICATION_FACTOR_DOC = "If automatic processing log topic creation is enabled, KSQL creates the topic with number of replicas set to the value of this property.";
    public static final String STREAM_AUTO_CREATE = ProcessingLogConfig.propertyName("stream.auto.create");
    private static final String STREAM_AUTO_CREATE_DOC = String.format("Toggles automatic processing log stream creation. If set to true, and running interactive mode on a new cluster, then KSQL will automatically create a processing log stream when it starts up. The name for the stream is the value of the \"%s\" property. The stream will be created over the topic set in the \"%s\" property", STREAM_NAME, TOPIC_NAME);
    public static final String TOPIC_AUTO_CREATE = ProcessingLogConfig.propertyName("topic.auto.create");
    private static final String TOPIC_AUTO_CREATE_DOC = String.format("Toggles automatic processing log topic creation. If set to true, then KSQL will automatically try to create a processing log topic at startup. The name of the topic is the value of the \"%s\" property. The number of partitions is taken from the \"%s\" property , and the replication factor is taken from the \"%s\" property", TOPIC_NAME, TOPIC_PARTITIONS, TOPIC_REPLICATION_FACTOR);
    public static final String INCLUDE_ROWS = ProcessingLogConfig.propertyName("rows.include");
    private static final String INCLUDE_ROWS_DOC = "Toggles whether or not the processing log should include rows in log messages";
    private static final ConfigDef CONFIG_DEF = new ConfigDef().define(STREAM_AUTO_CREATE, ConfigDef.Type.BOOLEAN, (Object)false, ConfigDef.Importance.MEDIUM, STREAM_AUTO_CREATE_DOC).define(STREAM_NAME, ConfigDef.Type.STRING, (Object)"KSQL_PROCESSING_LOG", ConfigDef.Importance.MEDIUM, "If automatic processing log stream creation is enabled, KSQL sets the name of the stream to the value of this property.").define(TOPIC_AUTO_CREATE, ConfigDef.Type.BOOLEAN, (Object)false, ConfigDef.Importance.MEDIUM, TOPIC_AUTO_CREATE_DOC).define(TOPIC_NAME, ConfigDef.Type.STRING, (Object)"", ConfigDef.Importance.MEDIUM, "If automatic processing log topic creation is enabled, KSQL sets the name of the topic to the value of this property. If automatic processing log stream creation is enabled, KSQL uses this topic to back the stream.").define(TOPIC_PARTITIONS, ConfigDef.Type.INT, (Object)1, ConfigDef.Importance.LOW, "If automatic processing log topic creation is enabled, KSQL creates the topic with number of partitions set to the value of this property.").define(TOPIC_REPLICATION_FACTOR, ConfigDef.Type.SHORT, (Object)1, ConfigDef.Importance.LOW, "If automatic processing log topic creation is enabled, KSQL creates the topic with number of replicas set to the value of this property.").define(INCLUDE_ROWS, ConfigDef.Type.BOOLEAN, (Object)false, ConfigDef.Importance.HIGH, "Toggles whether or not the processing log should include rows in log messages");

    private static String propertyName(String name) {
        return "ksql.logging.processing." + name;
    }

    public static Set<String> configNames() {
        return CONFIG_DEF.names();
    }

    public ProcessingLogConfig(Map<?, ?> properties) {
        super(CONFIG_DEF, properties);
    }
}

