/*
 * Decompiled with CFR 0.152.
 */
package io.confluent.ksql.parser;

import java.time.Duration;
import java.util.concurrent.TimeUnit;
import org.apache.commons.lang3.StringUtils;

public final class DurationParser {
    private DurationParser() {
    }

    public static Duration buildDuration(long size, String timeUnitName) {
        TimeUnit timeUnit = DurationParser.parseTimeUnit(timeUnitName.toUpperCase());
        return Duration.ofNanos(timeUnit.toNanos(size));
    }

    public static Duration parse(String text) {
        try {
            String[] parts = text.split("\\s");
            if (parts.length != 2) {
                throw new IllegalArgumentException("Expected 2 tokens, got: " + parts.length);
            }
            long size = DurationParser.parseNumeric(parts[0]);
            return DurationParser.buildDuration(size, parts[1]);
        }
        catch (Exception e) {
            throw new IllegalArgumentException("Invalid duration: '" + text + "'. " + e.getMessage(), e);
        }
    }

    private static long parseNumeric(String text) {
        try {
            return Long.parseLong(text);
        }
        catch (Exception e) {
            throw new IllegalArgumentException("Not numeric: '" + text + "'");
        }
    }

    private static TimeUnit parseTimeUnit(String text) {
        try {
            String timeUnit = text.endsWith("S") ? text : text + "S";
            return TimeUnit.valueOf(timeUnit);
        }
        catch (Exception e) {
            throw new IllegalArgumentException("Unknown time unit: '" + text + "'" + System.lineSeparator() + "Supported time units are: " + StringUtils.join((Object[])TimeUnit.values(), (String)", "));
        }
    }
}

