/*
 * Decompiled with CFR 0.152.
 */
package io.confluent.ksql.properties.with;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableSet;
import com.google.errorprone.annotations.Immutable;
import io.confluent.ksql.configdef.UnmodifiableConfigDef;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Comparator;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.stream.Collectors;
import org.apache.kafka.common.config.ConfigDef;

@Immutable
public final class ConfigMetaData {
    private final UnmodifiableConfigDef configDef;
    private final ImmutableSet<String> configNames;
    private final ImmutableList<String> orderedConfigNames;
    private final ImmutableSet<String> shortConfigs;

    static ConfigMetaData of(ConfigDef configDef) {
        return new ConfigMetaData(configDef);
    }

    private ConfigMetaData(ConfigDef configDef) {
        this.configDef = UnmodifiableConfigDef.of(Objects.requireNonNull(configDef, "configDef"));
        this.configNames = ConfigMetaData.configNames(configDef);
        this.orderedConfigNames = ConfigMetaData.orderedConfigNames(this.configNames);
        this.shortConfigs = ConfigMetaData.configsOfTypeShort(configDef);
    }

    public UnmodifiableConfigDef getConfigDef() {
        return this.configDef;
    }

    public Set<String> getConfigNames() {
        return this.configNames;
    }

    public List<String> getOrderedConfigNames() {
        return this.orderedConfigNames;
    }

    public Set<String> getShortConfigs() {
        return this.shortConfigs;
    }

    private static ImmutableSet<String> configNames(ConfigDef configDef) {
        return ImmutableSet.copyOf((Collection)configDef.names().stream().map(String::toUpperCase).collect(Collectors.toSet()));
    }

    private static ImmutableList<String> orderedConfigNames(Set<String> configNames) {
        ArrayList<String> names = new ArrayList<String>(configNames);
        names.sort(Comparator.naturalOrder());
        return ImmutableList.copyOf(names);
    }

    private static ImmutableSet<String> configsOfTypeShort(ConfigDef configDef) {
        return ImmutableSet.copyOf((Collection)configDef.configKeys().entrySet().stream().filter(e -> ((ConfigDef.ConfigKey)e.getValue()).type() == ConfigDef.Type.SHORT).map(Map.Entry::getKey).map(String::toUpperCase).collect(Collectors.toSet()));
    }
}

