/*
 * Decompiled with CFR 0.152.
 */
package io.confluent.ksql.util;

import java.util.Iterator;
import java.util.Objects;
import java.util.stream.Stream;

public final class GrammaticalJoiner {
    private final String separator;
    private final String lastSeparator;

    public static GrammaticalJoiner or() {
        return new GrammaticalJoiner(", ", " or ");
    }

    public static GrammaticalJoiner and() {
        return new GrammaticalJoiner(", ", " and ");
    }

    private GrammaticalJoiner(String separator, String lastSeparator) {
        this.separator = Objects.requireNonNull(separator, "separator");
        this.lastSeparator = Objects.requireNonNull(lastSeparator, "lastSeparator");
    }

    public String join(Stream<?> parts) {
        return this.join(parts.iterator());
    }

    public String join(Iterable<?> parts) {
        return this.join(parts.iterator());
    }

    private String join(Iterator<?> parts) {
        if (!parts.hasNext()) {
            return "";
        }
        String next = Objects.toString(parts.next());
        StringBuilder builder = new StringBuilder(next);
        while (parts.hasNext()) {
            next = Objects.toString(parts.next());
            builder.append(parts.hasNext() ? this.separator : this.lastSeparator).append(next);
        }
        return builder.toString();
    }
}

