/*
 * Decompiled with CFR 0.152.
 */
package io.confluent.ksql.util.timestamp;

import io.confluent.ksql.util.KsqlException;
import io.confluent.ksql.util.timestamp.StringToTimestampParser;
import java.sql.Timestamp;
import java.time.ZoneId;

public class PartialStringToTimestampParser {
    private static final String HELP_MESSAGE = System.lineSeparator() + "Required format is: \"" + "yyyy-MM-dd'T'HH:mm:ss.SSS" + "\", with an optional numeric 4-digit timezone, for example: '2020-05-26T23:59:58.000' or with tz: '2020-05-26T23:59:58.000+0200'. Partials are also supported, for example \"2020-05-26\"";
    private static final StringToTimestampParser PARSER = new StringToTimestampParser("yyyy-MM-dd'T'HH:mm:ss.SSS");

    public Timestamp parseToTimestamp(String text) {
        return new Timestamp(this.parse(text));
    }

    public long parse(String text) {
        String time;
        String timezone;
        String date;
        if (text.contains("T")) {
            date = text.substring(0, text.indexOf(84));
            String withTimezone = PartialStringToTimestampParser.completeTime(text.substring(text.indexOf(84) + 1));
            timezone = PartialStringToTimestampParser.getTimezone(withTimezone);
            time = PartialStringToTimestampParser.completeTime(withTimezone.substring(0, withTimezone.length() - timezone.length()));
        } else {
            date = PartialStringToTimestampParser.completeDate(text);
            time = PartialStringToTimestampParser.completeTime("");
            timezone = "";
        }
        try {
            ZoneId zoneId = PartialStringToTimestampParser.parseTimezone(timezone);
            return PARSER.parse(date + "T" + time, zoneId);
        }
        catch (RuntimeException e) {
            throw new KsqlException("Failed to parse timestamp '" + text + "': " + e.getMessage() + HELP_MESSAGE, e);
        }
    }

    private static String getTimezone(String time) {
        if (time.contains("+")) {
            return time.substring(time.indexOf(43));
        }
        if (time.contains("-")) {
            return time.substring(time.indexOf(45));
        }
        return "";
    }

    private static ZoneId parseTimezone(String timezone) {
        if (timezone.trim().isEmpty()) {
            return ZoneId.of("+0000");
        }
        try {
            return ZoneId.of(timezone);
        }
        catch (Exception e) {
            throw new KsqlException("Failed to parse timezone '" + timezone + "': " + e.getMessage(), e);
        }
    }

    private static String completeDate(String date) {
        String[] parts = date.split("-");
        if (parts.length == 1) {
            return date + "-01-01";
        }
        if (parts.length == 2) {
            return date + "-01";
        }
        return date;
    }

    private static String completeTime(String time) {
        if (time.length() >= "HH:mm:ss.SSS".length()) {
            return time;
        }
        return time + "HH:mm:ss.SSS".substring(time.length()).replaceAll("[a-zA-Z]", "0");
    }
}

