/*
 * Decompiled with CFR 0.152.
 */
package io.confluent.ksql.model;

import com.google.errorprone.annotations.Immutable;
import io.confluent.ksql.testing.EffectivelyImmutable;
import java.util.Comparator;
import java.util.Objects;

@Immutable
public final class SemanticVersion
implements Comparable<SemanticVersion> {
    @EffectivelyImmutable
    private static final Comparator<SemanticVersion> COMPARATOR = Comparator.comparingInt(SemanticVersion::major).thenComparingInt(SemanticVersion::minor).thenComparingInt(SemanticVersion::patch);
    private final int major;
    private final int minor;
    private final int patch;

    public static SemanticVersion of(int major, int minor, int patch) {
        return new SemanticVersion(major, minor, patch);
    }

    private SemanticVersion(int major, int minor, int patch) {
        this.major = major;
        this.minor = minor;
        this.patch = patch;
    }

    public int major() {
        return this.major;
    }

    public int minor() {
        return this.minor;
    }

    public int patch() {
        return this.patch;
    }

    @Override
    public int compareTo(SemanticVersion other) {
        return COMPARATOR.compare(this, other);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        SemanticVersion that = (SemanticVersion)o;
        return this.major == that.major && this.minor == that.minor && this.patch == that.patch;
    }

    public int hashCode() {
        return Objects.hash(this.major, this.minor, this.patch);
    }

    public String toString() {
        return this.major + "." + this.minor + "." + this.patch;
    }
}

