/*
 * Copyright 2019 Confluent Inc.
 *
 * Licensed under the Confluent Community License (the "License"; you may not use
 * this file except in compliance with the License. You may obtain a copy of the
 * License at
 *
 * http://www.confluent.io/confluent-community-license
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS, WITHOUT
 * WARRANTIES OF ANY KIND, either express or implied.  See the License for the
 * specific language governing permissions and limitations under the License.
 */

package io.confluent.ksql.rest.entity;

import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonProperty;
import java.util.Objects;

@JsonIgnoreProperties(ignoreUnknown = true)
public class DropConnectorEntity extends KsqlEntity {

  private final String connectorName;

  public DropConnectorEntity(
      @JsonProperty("statementText") final String statementText,
      @JsonProperty("connectorName") final String connectorName
  ) {
    super(statementText);
    this.connectorName = Objects.requireNonNull(connectorName, "connectorName");
  }

  public String getConnectorName() {
    return connectorName;
  }

  @Override
  public String toString() {
    return "DropConnectorEntity{"
        + "connectorName='" + connectorName + '\''
        + '}';
  }
}
