/*
 * Decompiled with CFR 0.152.
 */
package io.confluent.ksql.rest.client;

import io.confluent.ksql.rest.Errors;
import io.confluent.ksql.rest.entity.KsqlErrorMessage;
import io.netty.handler.codec.http.HttpResponseStatus;
import java.util.Objects;

public abstract class RestResponse<R> {
    private final int statusCode;

    private RestResponse(int statusCode) {
        this.statusCode = statusCode;
    }

    public boolean isSuccessful() {
        return this.statusCode == HttpResponseStatus.OK.code();
    }

    public boolean isErroneous() {
        return !this.isSuccessful();
    }

    public abstract KsqlErrorMessage getErrorMessage();

    public abstract R getResponse();

    public int getStatusCode() {
        return this.statusCode;
    }

    public static <R> RestResponse<R> erroneous(int statusCode, KsqlErrorMessage errorMessage) {
        return new Erroneous(statusCode, errorMessage);
    }

    public static <R> RestResponse<R> erroneous(int statusCode, String message) {
        return new Erroneous(statusCode, new KsqlErrorMessage(Errors.toErrorCode(statusCode), message));
    }

    public static <R> RestResponse<R> successful(int statusCode, R response) {
        return new Successful(statusCode, response);
    }

    public Object get() {
        if (this.isSuccessful()) {
            return this.getResponse();
        }
        return this.getErrorMessage();
    }

    private static final class Successful<R>
    extends RestResponse<R> {
        private final R response;

        private Successful(int statusCode, R response) {
            super(statusCode);
            this.response = response;
            if (statusCode != HttpResponseStatus.OK.code()) {
                throw new IllegalArgumentException("Error code passed to success!");
            }
        }

        @Override
        public KsqlErrorMessage getErrorMessage() {
            throw new UnsupportedOperationException();
        }

        @Override
        public R getResponse() {
            return this.response;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (!(o instanceof Successful)) {
                return false;
            }
            Successful that = (Successful)o;
            return Objects.equals(this.getResponse(), that.getResponse()) && Objects.equals(this.getStatusCode(), that.getStatusCode());
        }

        public int hashCode() {
            return Objects.hash(this.getResponse(), this.getStatusCode());
        }

        public String toString() {
            return "Successful{statusCode=" + this.getStatusCode() + ", response=" + this.response + '}';
        }
    }

    private static final class Erroneous<R>
    extends RestResponse<R> {
        private final KsqlErrorMessage errorMessage;

        private Erroneous(int statusCode, KsqlErrorMessage errorMessage) {
            super(statusCode);
            this.errorMessage = errorMessage;
            if (statusCode == HttpResponseStatus.OK.code()) {
                throw new IllegalArgumentException("Success code passed to error!");
            }
        }

        @Override
        public KsqlErrorMessage getErrorMessage() {
            return this.errorMessage;
        }

        @Override
        public R getResponse() {
            throw new UnsupportedOperationException("error msg: " + this.errorMessage);
        }

        public String toString() {
            return "Erroneous{statusCode=" + this.getStatusCode() + ", errorMessage=" + this.errorMessage + '}';
        }
    }
}

