/*
 * Decompiled with CFR 0.152.
 */
package io.confluent.ksql.rest.entity;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonSubTypes;
import com.fasterxml.jackson.annotation.JsonTypeInfo;
import io.confluent.ksql.rest.entity.KsqlStatementErrorMessage;
import io.confluent.ksql.util.ErrorMessageUtil;
import java.util.Arrays;
import java.util.List;
import java.util.Objects;
import java.util.stream.Collectors;

@JsonIgnoreProperties(ignoreUnknown=true)
@JsonTypeInfo(use=JsonTypeInfo.Id.NAME)
@JsonSubTypes(value={@JsonSubTypes.Type(value=KsqlErrorMessage.class, name="generic_error"), @JsonSubTypes.Type(value=KsqlStatementErrorMessage.class, name="statement_error")})
public class KsqlErrorMessage {
    private final int errorCode;
    private final String errorMessage;

    @JsonCreator
    public KsqlErrorMessage(@JsonProperty(value="error_code") int errorCode, @JsonProperty(value="message") String message) {
        this.errorCode = errorCode;
        this.errorMessage = message == null ? "" : message;
    }

    public KsqlErrorMessage(int errorCode, Throwable exception) {
        this(errorCode, ErrorMessageUtil.buildErrorMessage((Throwable)exception));
    }

    static List<String> getStackTraceStrings(Throwable exception) {
        return Arrays.stream(exception.getStackTrace()).map(StackTraceElement::toString).collect(Collectors.toList());
    }

    @JsonProperty(value="error_code")
    public int getErrorCode() {
        return this.errorCode;
    }

    public String getMessage() {
        return this.errorMessage;
    }

    public String toString() {
        return this.errorMessage;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        KsqlErrorMessage that = (KsqlErrorMessage)o;
        return this.errorCode == that.errorCode && this.errorMessage.equals(that.errorMessage);
    }

    public int hashCode() {
        return Objects.hash(this.errorCode, this.errorMessage);
    }
}

