/*
 * Decompiled with CFR 0.152.
 */
package io.confluent.ksql.rest.entity;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonProperty;
import io.confluent.ksql.rest.entity.KsqlEntity;
import java.util.Collections;
import java.util.List;
import java.util.Objects;

@JsonIgnoreProperties(ignoreUnknown=true)
public class PropertiesList
extends KsqlEntity {
    private final List<Property> properties;
    private final List<String> overwrittenProperties;
    private final List<String> defaultProperties;

    @JsonCreator
    public PropertiesList(@JsonProperty(value="statementText") String statementText, @JsonProperty(value="properties") List<Property> properties, @JsonProperty(value="overwrittenProperties") List<String> overwrittenProperties, @JsonProperty(value="defaultProperties") List<String> defaultProperties) {
        super(statementText);
        this.properties = properties == null ? Collections.emptyList() : properties;
        this.overwrittenProperties = overwrittenProperties == null ? Collections.emptyList() : overwrittenProperties;
        this.defaultProperties = defaultProperties == null ? Collections.emptyList() : defaultProperties;
    }

    public List<Property> getProperties() {
        return this.properties;
    }

    public List<String> getOverwrittenProperties() {
        return this.overwrittenProperties;
    }

    public List<String> getDefaultProperties() {
        return this.defaultProperties;
    }

    public boolean equals(Object o) {
        return o instanceof PropertiesList && Objects.equals(this.properties, ((PropertiesList)o).properties) && Objects.equals(this.overwrittenProperties, ((PropertiesList)o).overwrittenProperties) && Objects.equals(this.defaultProperties, ((PropertiesList)o).defaultProperties);
    }

    public int hashCode() {
        return Objects.hash(this.properties, this.overwrittenProperties, this.defaultProperties);
    }

    @JsonIgnoreProperties(ignoreUnknown=true)
    public static class Property {
        private final String name;
        private final String scope;
        private final String value;

        @JsonCreator
        public Property(@JsonProperty(value="name") String name, @JsonProperty(value="scope") String scope, @JsonProperty(value="value") String value) {
            this.name = name;
            this.scope = scope;
            this.value = value;
        }

        public String getName() {
            return this.name;
        }

        public String getScope() {
            return this.scope;
        }

        public String getValue() {
            return this.value;
        }

        public boolean equals(Object object) {
            if (this == object) {
                return true;
            }
            if (object == null || this.getClass() != object.getClass()) {
                return false;
            }
            Property that = (Property)object;
            return Objects.equals(this.name, that.name) && Objects.equals(this.scope, that.scope) && Objects.equals(this.value, that.value);
        }

        public int hashCode() {
            return Objects.hash(this.name, this.scope, this.value);
        }

        public String toString() {
            return "Property{name='" + this.name + '\'' + ", scope='" + this.scope + '\'' + ", value='" + this.value + '\'' + '}';
        }
    }
}

