/*
 * Decompiled with CFR 0.152.
 */
package io.confluent.ksql.rest.entity;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonSubTypes;
import com.google.common.collect.ImmutableMap;
import io.confluent.ksql.config.PropertyParser;
import io.confluent.ksql.properties.LocalPropertyParser;
import io.confluent.ksql.util.KsqlException;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.stream.Collectors;

@JsonIgnoreProperties(ignoreUnknown=true)
@JsonSubTypes(value={})
public class KsqlRequest {
    private static final PropertyParser PROPERTY_PARSER = new LocalPropertyParser();
    private final String ksql;
    private final ImmutableMap<String, Object> configOverrides;
    private final ImmutableMap<String, Object> requestProperties;
    private final Optional<Long> commandSequenceNumber;

    @JsonCreator
    public KsqlRequest(@JsonProperty(value="ksql") String ksql, @JsonProperty(value="streamsProperties") Map<String, ?> configOverrides, @JsonProperty(value="requestProperties") Map<String, ?> requestProperties, @JsonProperty(value="commandSequenceNumber") Long commandSequenceNumber) {
        this.ksql = ksql == null ? "" : ksql;
        this.configOverrides = configOverrides == null ? ImmutableMap.of() : ImmutableMap.copyOf(KsqlRequest.serializeClassValues(configOverrides));
        this.requestProperties = requestProperties == null ? ImmutableMap.of() : ImmutableMap.copyOf(KsqlRequest.serializeClassValues(requestProperties));
        this.commandSequenceNumber = Optional.ofNullable(commandSequenceNumber);
    }

    public String getKsql() {
        return this.ksql;
    }

    @JsonProperty(value="streamsProperties")
    public Map<String, Object> getConfigOverrides() {
        return KsqlRequest.coerceTypes(this.configOverrides);
    }

    public Map<String, Object> getRequestProperties() {
        return KsqlRequest.coerceTypes(this.requestProperties);
    }

    public Optional<Long> getCommandSequenceNumber() {
        return this.commandSequenceNumber;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof KsqlRequest)) {
            return false;
        }
        KsqlRequest that = (KsqlRequest)o;
        return Objects.equals(this.ksql, that.ksql) && Objects.equals(this.configOverrides, that.configOverrides) && Objects.equals(this.requestProperties, that.requestProperties) && Objects.equals(this.commandSequenceNumber, that.commandSequenceNumber);
    }

    public int hashCode() {
        return Objects.hash(this.ksql, this.configOverrides, this.requestProperties, this.commandSequenceNumber);
    }

    public String toString() {
        return "KsqlRequest{ksql='" + this.ksql + '\'' + ", configOverrides=" + this.configOverrides + ", requestProperties=" + this.requestProperties + ", commandSequenceNumber=" + this.commandSequenceNumber + '}';
    }

    private static Map<String, ?> serializeClassValues(Map<String, ?> properties) {
        return properties.entrySet().stream().collect(Collectors.toMap(Map.Entry::getKey, kv -> {
            if (kv.getValue() instanceof Class) {
                return ((Class)kv.getValue()).getCanonicalName();
            }
            return kv.getValue();
        }));
    }

    private static Map<String, Object> coerceTypes(Map<String, Object> streamsProperties) {
        if (streamsProperties == null) {
            return Collections.emptyMap();
        }
        HashMap<String, Object> validated = new HashMap<String, Object>(streamsProperties.size());
        streamsProperties.forEach((k, v) -> validated.put((String)k, KsqlRequest.coerceType(k, v)));
        return validated;
    }

    private static Object coerceType(String key, Object value) {
        try {
            String stringValue = value == null ? null : (value instanceof List ? KsqlRequest.listToString((List)value) : String.valueOf(value));
            return PROPERTY_PARSER.parse(key, (Object)stringValue);
        }
        catch (Exception e) {
            throw new KsqlException("Failed to set '" + key + "' to '" + value + "'", (Throwable)e);
        }
    }

    private static String listToString(List<?> value) {
        return value.stream().map(e -> e == null ? null : e.toString()).collect(Collectors.joining(","));
    }
}

