/*
 * Decompiled with CFR 0.152.
 */
package io.confluent.ksql.serde;

import com.google.common.base.Preconditions;
import io.confluent.ksql.serde.SerdeUtils;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.function.Function;
import org.apache.kafka.common.serialization.Serializer;

class GenericSerializer<T>
implements Serializer<T> {
    private final Function<T, List<?>> accessor;
    private final Serializer<List<?>> inner;
    private final int numColumns;

    GenericSerializer(Function<T, List<?>> accessor, Serializer<List<?>> inner, int expectedNumColumns) {
        this.inner = Objects.requireNonNull(inner, "inner");
        this.accessor = Objects.requireNonNull(accessor, "accessor");
        this.numColumns = expectedNumColumns;
        Preconditions.checkArgument((expectedNumColumns >= 0 ? 1 : 0) != 0, (Object)("negative expected column count: " + expectedNumColumns));
    }

    public void configure(Map<String, ?> configs, boolean isKey) {
        this.inner.configure(configs, isKey);
    }

    public byte[] serialize(String topic, T data) {
        if (data == null) {
            return this.inner.serialize(topic, null);
        }
        List<?> list = this.accessor.apply(data);
        SerdeUtils.throwOnColumnCountMismatch(this.numColumns, list.size(), true, topic);
        return this.inner.serialize(topic, list);
    }

    public void close() {
        this.inner.close();
    }
}

