/*
 * Decompiled with CFR 0.152.
 */
package io.confluent.ksql.serde;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.google.common.collect.ImmutableMap;
import com.google.errorprone.annotations.Immutable;
import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import io.confluent.ksql.model.WindowType;
import io.confluent.ksql.serde.FormatInfo;
import io.confluent.ksql.serde.SerdeFeature;
import io.confluent.ksql.serde.SerdeFeatures;
import io.confluent.ksql.serde.WindowInfo;
import java.time.Duration;
import java.util.HashSet;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;

@Immutable
public final class KeyFormat {
    private final FormatInfo format;
    private final SerdeFeatures features;
    private final Optional<WindowInfo> window;

    public static KeyFormat nonWindowed(FormatInfo format, SerdeFeatures features) {
        return new KeyFormat(format, features, Optional.empty());
    }

    public static KeyFormat windowed(FormatInfo format, SerdeFeatures features, WindowInfo windowInfo) {
        return new KeyFormat(format, features, Optional.of(windowInfo));
    }

    public static KeyFormat of(FormatInfo format, SerdeFeatures features, Optional<WindowInfo> windowInfo) {
        return new KeyFormat(format, features, windowInfo);
    }

    @JsonCreator
    @SuppressFBWarnings(value={"UPM_UNCALLED_PRIVATE_METHOD"})
    private static KeyFormat of(@JsonProperty(value="format", required=true) String format, @JsonProperty(value="properties") Optional<Map<String, String>> properties, @JsonProperty(value="features") Optional<SerdeFeatures> features, @JsonProperty(value="windowInfo") Optional<WindowInfo> windowInfo) {
        return new KeyFormat(FormatInfo.of((String)format, (Map)properties.orElseGet(ImmutableMap::of)), features.orElseGet(() -> SerdeFeatures.of((SerdeFeature[])new SerdeFeature[0])), windowInfo);
    }

    private KeyFormat(FormatInfo format, SerdeFeatures features, Optional<WindowInfo> window) {
        this.format = Objects.requireNonNull(format, "format");
        this.features = Objects.requireNonNull(features, "features");
        this.window = Objects.requireNonNull(window, "window");
    }

    public String getFormat() {
        return this.format.getFormat();
    }

    public Map<String, String> getProperties() {
        return this.format.getProperties();
    }

    @JsonIgnore
    public FormatInfo getFormatInfo() {
        return this.format;
    }

    @JsonIgnore
    public boolean isWindowed() {
        return this.window.isPresent();
    }

    public Optional<WindowInfo> getWindowInfo() {
        return this.window;
    }

    @JsonIgnore
    public Optional<WindowType> getWindowType() {
        return this.window.map(WindowInfo::getType);
    }

    @JsonIgnore
    public Optional<Duration> getWindowSize() {
        return this.window.flatMap(WindowInfo::getSize);
    }

    @JsonInclude(value=JsonInclude.Include.CUSTOM, valueFilter=SerdeFeatures.NOT_EMPTY.class)
    public SerdeFeatures getFeatures() {
        return this.features;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        KeyFormat keyFormat = (KeyFormat)o;
        return Objects.equals(this.format, keyFormat.format) && Objects.equals(this.features, keyFormat.features) && Objects.equals(this.window, keyFormat.window);
    }

    public int hashCode() {
        return Objects.hash(this.format, this.features, this.window);
    }

    public String toString() {
        return "KeyFormat{format=" + this.format + ", features=" + this.features + ", window=" + this.window + '}';
    }

    public KeyFormat withSerdeFeatures(SerdeFeatures additionalFeatures) {
        HashSet features = new HashSet(this.features.all());
        features.addAll(additionalFeatures.all());
        return new KeyFormat(this.format, SerdeFeatures.from(features), this.window);
    }

    public KeyFormat withoutSerdeFeatures(SerdeFeatures featuresToRemove) {
        HashSet features = new HashSet(this.features.all());
        features.removeAll(featuresToRemove.all());
        return new KeyFormat(this.format, SerdeFeatures.from(features), this.window);
    }
}

