/*
 * Decompiled with CFR 0.152.
 */
package io.confluent.ksql.serde;

import com.google.common.collect.Sets;
import io.confluent.kafka.schemaregistry.ParsedSchema;
import io.confluent.kafka.schemaregistry.client.SchemaRegistryClient;
import io.confluent.kafka.schemaregistry.client.rest.exceptions.RestClientException;
import io.confluent.ksql.schema.ksql.SchemaConverters;
import io.confluent.ksql.serde.SerdeFeature;
import io.confluent.ksql.serde.SerdeFeatures;
import io.confluent.ksql.serde.connect.ConnectSchemaTranslator;
import io.confluent.ksql.serde.unwrapped.UnwrappedDeserializer;
import io.confluent.ksql.serde.unwrapped.UnwrappedSerializer;
import io.confluent.ksql.util.KsqlException;
import java.io.IOException;
import java.sql.Date;
import java.sql.Time;
import java.util.List;
import java.util.Set;
import java.util.concurrent.TimeUnit;
import java.util.function.Supplier;
import org.apache.kafka.common.errors.SerializationException;
import org.apache.kafka.common.serialization.Deserializer;
import org.apache.kafka.common.serialization.Serializer;
import org.apache.kafka.connect.data.ConnectSchema;
import org.apache.kafka.connect.data.Field;
import org.apache.kafka.connect.data.Schema;
import org.apache.kafka.connect.data.SchemaBuilder;

public final class SerdeUtils {
    private SerdeUtils() {
    }

    public static void throwOnUnsupportedFeatures(SerdeFeatures requestedFeatures, Set<SerdeFeature> supportedFeatures) {
        Sets.SetView unsupported = Sets.difference((Set)requestedFeatures.all(), supportedFeatures);
        if (!unsupported.isEmpty()) {
            throw new IllegalArgumentException("Unsupported features: " + unsupported);
        }
    }

    public static ConnectSchema applySinglesUnwrapping(Schema schema, SerdeFeatures features) {
        boolean singleField;
        if (!features.enabled(SerdeFeature.UNWRAP_SINGLES)) {
            return (ConnectSchema)schema;
        }
        boolean bl = singleField = schema.fields().size() == 1;
        if (!singleField) {
            throw new IllegalArgumentException("Unwrapping only valid for single columns");
        }
        return (ConnectSchema)((Field)schema.fields().get(0)).schema();
    }

    public static Schema wrapSingle(Schema fieldSchema, boolean isKey) {
        String fieldName = isKey ? "ROWKEY" : "ROWVAL";
        return SchemaBuilder.struct().field(fieldName, fieldSchema).build();
    }

    public static <T> Serializer<List<?>> unwrappedSerializer(Serializer<T> inner, Class<T> type) {
        return new UnwrappedSerializer<T>(inner, type);
    }

    public static Deserializer<List<?>> unwrappedDeserializer(Deserializer<?> inner) {
        return new UnwrappedDeserializer(inner);
    }

    public static <T> T safeCast(Object value, Class<T> javaType) {
        if (value != null && !javaType.isAssignableFrom(value.getClass())) {
            throw new SerializationException("value does not match expected type. expected: " + javaType.getSimpleName() + ", but got: " + value.getClass().getSimpleName());
        }
        return (T)value;
    }

    public static void throwOnSchemaJavaTypeMismatch(Schema schema, Class<?> javaType) {
        Class schemaType = SchemaConverters.connectToJavaTypeConverter().toJavaType(schema);
        if (!schemaType.equals(javaType)) {
            throw new IllegalArgumentException("schema does not match expected java type. Expected: " + javaType + ", but got " + schemaType);
        }
    }

    public static void throwOnColumnCountMismatch(int expectedCount, int actualCount, boolean serialization, String topic) {
        if (expectedCount == actualCount) {
            return;
        }
        throw new SerializationException("Column count mismatch on " + (serialization ? "serialization" : "deserialization") + ". topic: " + topic + ", expected: " + expectedCount + ", got: " + actualCount);
    }

    public static <T> T castToTargetType(Object val, Class<T> type) {
        if (val != null && !type.isAssignableFrom(val.getClass())) {
            throw new SerializationException("Data deserialized to wrong type. Expected type: " + type + ", but got: " + val);
        }
        return (T)val;
    }

    public static Time returnTimeOrThrow(long time) {
        if (time >= 0L && time <= TimeUnit.DAYS.toMillis(1L)) {
            return new Time(time);
        }
        throw new IllegalArgumentException("Time values must use number of milliseconds greater than 0 and less than " + TimeUnit.DAYS.toMillis(1L) + ".");
    }

    public static Date getDateFromEpochDays(long days) {
        return new Date(TimeUnit.DAYS.toMillis(days));
    }

    public static int toEpochDays(Date date) {
        long days = TimeUnit.MILLISECONDS.toDays(date.getTime());
        if (date.getTime() == TimeUnit.DAYS.toMillis(days)) {
            return (int)days;
        }
        throw new IllegalArgumentException("Date type should not have any time fields set to non-zero values.");
    }

    public static ParsedSchema getParsedSchemaById(Supplier<SchemaRegistryClient> srFactory, int schemaId) {
        try {
            return srFactory.get().getSchemaById(schemaId);
        }
        catch (RestClientException | IOException e) {
            throw new KsqlException("Failed to fetch schema for serialization from Schema Registry using schema id: " + schemaId, e);
        }
    }

    public static int getLatestSchemaId(Supplier<SchemaRegistryClient> srFactory, String subjectName) {
        try {
            return srFactory.get().getLatestSchemaMetadata(subjectName).getId();
        }
        catch (RestClientException | IOException e) {
            throw new KsqlException("Failed to fetch schema for serialization from Schema Registry using schema subject: " + subjectName, e);
        }
    }

    public static Schema getAndTranslateSchemaById(Supplier<SchemaRegistryClient> srFactory, int schemaId, ConnectSchemaTranslator translator) {
        try {
            ParsedSchema parsedSchema = srFactory.get().getSchemaById(schemaId);
            return translator.toConnectSchema(parsedSchema);
        }
        catch (RestClientException | IOException e) {
            throw new KsqlException("Failed to fetch schema for serialization from Schema Registry using schema id: " + schemaId, e);
        }
    }
}

