/*
 * Decompiled with CFR 0.152.
 */
package io.confluent.ksql.serde;

import com.google.common.annotations.VisibleForTesting;
import io.confluent.ksql.logging.processing.LoggingDeserializer;
import java.util.Map;
import java.util.Objects;
import org.apache.kafka.common.serialization.Deserializer;
import org.apache.kafka.common.serialization.Serde;
import org.apache.kafka.common.serialization.Serializer;

public final class StaticTopicSerde<T>
implements Serde<T> {
    private final Serde<T> delegate;
    private final String topic;
    private final Callback onFailure;

    public static <S> Serde<S> wrap(String topic, Serde<S> serde, Callback onFailure) {
        return new StaticTopicSerde<S>(topic, serde, onFailure);
    }

    private StaticTopicSerde(String topic, Serde<T> delegate, Callback onFailure) {
        this.topic = Objects.requireNonNull(topic, "topic");
        this.delegate = Objects.requireNonNull(delegate, "delegate");
        this.onFailure = Objects.requireNonNull(onFailure, "onFailure");
    }

    public void configure(Map<String, ?> configs, boolean isKey) {
        this.delegate.configure(configs, isKey);
    }

    public void close() {
        this.delegate.close();
    }

    public Serializer<T> serializer() {
        Serializer serializer = this.delegate.serializer();
        return (topic, data) -> serializer.serialize(this.topic, data);
    }

    public Deserializer<T> deserializer() {
        Deserializer deserializer = this.delegate.deserializer();
        if (deserializer instanceof LoggingDeserializer) {
            LoggingDeserializer loggingDeserializer = (LoggingDeserializer)deserializer;
            return (topic, data) -> {
                LoggingDeserializer.DelayedResult staticResult = loggingDeserializer.tryDeserialize(this.topic, data);
                if (!staticResult.isError()) {
                    return staticResult.get();
                }
                LoggingDeserializer.DelayedResult sourceResult = loggingDeserializer.tryDeserialize(topic, data);
                if (sourceResult.isError()) {
                    return staticResult.get();
                }
                this.onFailure.onDeserializationFailure(topic, this.topic, data);
                return sourceResult.get();
            };
        }
        return (topic, data) -> {
            try {
                return deserializer.deserialize(this.topic, data);
            }
            catch (Exception e) {
                Object object = deserializer.deserialize(topic, data);
                this.onFailure.onDeserializationFailure(topic, this.topic, data);
                return object;
            }
        };
    }

    @VisibleForTesting
    public String getTopic() {
        return this.topic;
    }

    @VisibleForTesting
    public Callback getOnFailure() {
        return this.onFailure;
    }

    public static interface Callback {
        public void onDeserializationFailure(String var1, String var2, byte[] var3);
    }
}

