/*
 * Decompiled with CFR 0.152.
 */
package io.confluent.ksql.serde.connect;

import io.confluent.ksql.serde.SerdeUtils;
import io.confluent.ksql.serde.connect.DataTranslator;
import java.nio.ByteBuffer;
import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import org.apache.kafka.connect.data.Field;
import org.apache.kafka.connect.data.Schema;
import org.apache.kafka.connect.data.Struct;
import org.apache.kafka.connect.data.Time;
import org.apache.kafka.connect.errors.DataException;

public class ConnectDataTranslator
implements DataTranslator {
    private static final String PATH_SEPARATOR = "->";
    private final Schema schema;
    private static final Schema.Type[] INT64_ACCEPTABLE_TYPES = new Schema.Type[]{Schema.Type.INT64, Schema.Type.INT32, Schema.Type.INT16, Schema.Type.INT8};
    private static final Schema.Type[] INT32_ACCEPTABLE_TYPES = new Schema.Type[]{Schema.Type.INT32, Schema.Type.INT16, Schema.Type.INT8};
    private static final Schema.Type[] FLOAT64_ACCEPTABLE_TYPES = new Schema.Type[]{Schema.Type.FLOAT32, Schema.Type.FLOAT64};
    private static final Schema.Type[] STRING_ACCEPTABLE_TYPES = new Schema.Type[]{Schema.Type.INT8, Schema.Type.INT16, Schema.Type.INT32, Schema.Type.INT64, Schema.Type.FLOAT32, Schema.Type.FLOAT64, Schema.Type.BOOLEAN, Schema.Type.STRING};

    public ConnectDataTranslator(Schema schema) {
        this.schema = Objects.requireNonNull(schema, "schema");
    }

    @Override
    public Object toKsqlRow(Schema connectSchema, Object connectData) {
        if (connectData == null) {
            return null;
        }
        return this.toKsqlValue(this.schema, connectSchema, connectData, "");
    }

    public Schema getSchema() {
        return this.schema;
    }

    @Override
    public Object toConnectRow(Object ksqlData) {
        return ksqlData;
    }

    private static void throwTypeMismatchException(String pathStr, Schema schema, Schema connectSchema) {
        throw new DataException(String.format("Cannot deserialize type %s as type %s for path: %s", connectSchema.type().getName(), schema.type().getName(), pathStr));
    }

    private static void validateType(String pathStr, Schema schema, Schema connectSchema, Schema.Type[] validTypes) {
        for (Schema.Type type : validTypes) {
            if (!connectSchema.type().equals((Object)type)) continue;
            return;
        }
        ConnectDataTranslator.throwTypeMismatchException(pathStr, schema, connectSchema);
    }

    private static void validateType(String pathStr, Schema schema, Schema connectSchema) {
        if (!connectSchema.type().equals((Object)schema.type())) {
            ConnectDataTranslator.throwTypeMismatchException(pathStr, schema, connectSchema);
        }
    }

    private static void validateSchema(String pathStr, Schema schema, Schema connectSchema) {
        switch (schema.type()) {
            case BOOLEAN: 
            case ARRAY: 
            case MAP: 
            case STRUCT: 
            case BYTES: {
                ConnectDataTranslator.validateType(pathStr, schema, connectSchema);
                break;
            }
            case STRING: {
                ConnectDataTranslator.validateType(pathStr, schema, connectSchema, STRING_ACCEPTABLE_TYPES);
                break;
            }
            case INT64: {
                ConnectDataTranslator.validateType(pathStr, schema, connectSchema, INT64_ACCEPTABLE_TYPES);
                break;
            }
            case INT32: {
                ConnectDataTranslator.validateType(pathStr, schema, connectSchema, INT32_ACCEPTABLE_TYPES);
                break;
            }
            case FLOAT64: {
                ConnectDataTranslator.validateType(pathStr, schema, connectSchema, FLOAT64_ACCEPTABLE_TYPES);
                break;
            }
            default: {
                throw new RuntimeException("Unexpected data type seen in schema: " + schema.type().getName());
            }
        }
    }

    private static Object maybeConvertLogicalType(Schema connectSchema, Object connectValue) {
        if (connectSchema.name() == null) {
            return connectValue;
        }
        switch (connectSchema.name()) {
            case "org.apache.kafka.connect.data.Date": {
                return org.apache.kafka.connect.data.Date.fromLogical((Schema)connectSchema, (Date)((Date)connectValue));
            }
            case "org.apache.kafka.connect.data.Time": {
                return Time.fromLogical((Schema)connectSchema, (Date)((Date)connectValue));
            }
            case "org.apache.kafka.connect.data.Timestamp": {
                return org.apache.kafka.connect.data.Timestamp.fromLogical((Schema)connectSchema, (Date)((Date)connectValue));
            }
        }
        return connectValue;
    }

    private Object toKsqlValue(Schema schema, Schema connectSchema, Object connectValue, String pathStr) {
        if (connectSchema == null) {
            return null;
        }
        ConnectDataTranslator.validateSchema(pathStr, schema, connectSchema);
        if (connectValue == null) {
            return null;
        }
        Object convertedValue = ConnectDataTranslator.maybeConvertLogicalType(connectSchema, connectValue);
        switch (schema.type()) {
            case INT64: {
                if (schema.name() == "org.apache.kafka.connect.data.Timestamp") {
                    return new Timestamp(((Number)convertedValue).longValue());
                }
                return ((Number)convertedValue).longValue();
            }
            case INT32: {
                int intVal = ((Number)convertedValue).intValue();
                if (schema.name() == "org.apache.kafka.connect.data.Time") {
                    return new java.sql.Time(intVal);
                }
                if (schema.name() == "org.apache.kafka.connect.data.Date") {
                    return SerdeUtils.getDateFromEpochDays(intVal);
                }
                return intVal;
            }
            case FLOAT64: {
                return ((Number)convertedValue).doubleValue();
            }
            case ARRAY: {
                return this.toKsqlArray(schema.valueSchema(), connectSchema.valueSchema(), (List)convertedValue, pathStr);
            }
            case MAP: {
                return this.toKsqlMap(schema.keySchema(), connectSchema.keySchema(), schema.valueSchema(), connectSchema.valueSchema(), (Map)convertedValue, pathStr);
            }
            case STRUCT: {
                return this.toKsqlStruct(schema, connectSchema, (Struct)convertedValue, pathStr);
            }
            case STRING: {
                return String.valueOf(convertedValue);
            }
            case BYTES: {
                if (convertedValue instanceof byte[]) {
                    return ByteBuffer.wrap((byte[])convertedValue);
                }
                return convertedValue;
            }
        }
        return convertedValue;
    }

    private List<?> toKsqlArray(Schema valueSchema, Schema connectValueSchema, List<Object> connectArray, String pathStr) {
        ArrayList ksqlArray = new ArrayList(connectArray.size());
        connectArray.forEach(item -> ksqlArray.add(this.toKsqlValue(valueSchema, connectValueSchema, item, pathStr + PATH_SEPARATOR + "ARRAY")));
        return ksqlArray;
    }

    private Map<?, ?> toKsqlMap(Schema keySchema, Schema connectKeySchema, Schema valueSchema, Schema connectValueSchema, Map<Object, Object> connectMap, String pathStr) {
        HashMap ksqlMap = new HashMap();
        connectMap.forEach((key, value) -> ksqlMap.put(this.toKsqlValue(keySchema, connectKeySchema, key, pathStr + PATH_SEPARATOR + "MAP_KEY"), this.toKsqlValue(valueSchema, connectValueSchema, value, pathStr + PATH_SEPARATOR + "MAP_VAL")));
        return ksqlMap;
    }

    private Struct toKsqlStruct(Schema schema, Schema connectSchema, Struct connectStruct, String pathStr) {
        Struct ksqlStruct = new Struct(schema);
        for (Field field : connectSchema.fields()) {
            Field ksqlField = schema.field(field.name());
            if (ksqlField == null && (ksqlField = schema.field(field.name().toUpperCase())) == null) continue;
            Object fieldValue = connectStruct.get(field);
            Schema fieldSchema = field.schema();
            ksqlStruct.put(ksqlField, this.toKsqlValue(ksqlField.schema(), fieldSchema, fieldValue, pathStr + PATH_SEPARATOR + ksqlField.name()));
        }
        return ksqlStruct;
    }
}

