/*
 * Decompiled with CFR 0.152.
 */
package io.confluent.ksql.serde.connect;

import io.confluent.ksql.serde.SerdeUtils;
import io.confluent.ksql.serde.connect.DataTranslator;
import java.util.Map;
import java.util.Objects;
import org.apache.kafka.common.errors.SerializationException;
import org.apache.kafka.common.serialization.Deserializer;
import org.apache.kafka.connect.data.SchemaAndValue;
import org.apache.kafka.connect.storage.Converter;

public class KsqlConnectDeserializer<T>
implements Deserializer<T> {
    private final Converter converter;
    private final DataTranslator translator;
    private final Class<T> targetType;

    public KsqlConnectDeserializer(Converter converter, DataTranslator translator, Class<T> targetType) {
        this.converter = Objects.requireNonNull(converter, "converter");
        this.translator = Objects.requireNonNull(translator, "translator");
        this.targetType = Objects.requireNonNull(targetType, "type");
    }

    public void configure(Map<String, ?> map, boolean b) {
    }

    public T deserialize(String topic, byte[] bytes) {
        try {
            SchemaAndValue schemaAndValue = this.converter.toConnectData(topic, bytes);
            Object val = this.translator.toKsqlRow(schemaAndValue.schema(), schemaAndValue.value());
            return SerdeUtils.castToTargetType(val, this.targetType);
        }
        catch (Exception e) {
            throw new SerializationException("Error deserializing message from topic: " + topic, (Throwable)e);
        }
    }

    public void close() {
    }
}

