/*
 * Decompiled with CFR 0.152.
 */
package io.confluent.ksql.serde.unwrapped;

import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import org.apache.kafka.common.header.Headers;
import org.apache.kafka.common.serialization.Deserializer;

public class UnwrappedDeserializer
implements Deserializer<List<?>> {
    private final Deserializer<?> inner;

    public UnwrappedDeserializer(Deserializer<?> inner) {
        this.inner = Objects.requireNonNull(inner, "inner");
    }

    public void configure(Map<String, ?> configs, boolean isKey) {
        this.inner.configure(configs, isKey);
    }

    public List<?> deserialize(String topic, byte[] bytes) {
        if (bytes == null) {
            return null;
        }
        Object single = this.inner.deserialize(topic, bytes);
        return Collections.singletonList(single);
    }

    public List<?> deserialize(String topic, Headers headers, byte[] bytes) {
        if (bytes == null) {
            return null;
        }
        Object single = this.inner.deserialize(topic, headers, bytes);
        return Collections.singletonList(single);
    }

    public void close() {
        this.inner.close();
    }
}

