/*
 * Decompiled with CFR 0.152.
 */
package io.confluent.licenses;

import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import org.apache.commons.compress.archivers.jar.JarArchiveEntry;
import org.apache.commons.compress.archivers.jar.JarArchiveInputStream;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class JarUtils {
    static String contentReader(JarArchiveInputStream jarArchiveInputStream, JarArchiveEntry jarArchiveEntry) throws IOException {
        StringBuffer stringBuffer = new StringBuffer();
        byte[] content = new byte[1024];
        int amtRead = 0;
        while (amtRead >= 0) {
            amtRead = jarArchiveInputStream.read(content, 0, 1024);
            if (amtRead <= 0) continue;
            stringBuffer.append(new String(content, 0, amtRead));
        }
        return stringBuffer.toString();
    }

    static File contentToFile(JarArchiveInputStream jarArchiveInputStream, JarArchiveEntry jarArchiveEntry) throws IOException {
        StringBuffer stringBuffer = new StringBuffer();
        File file = File.createTempFile("pom", ".xml");
        FileOutputStream fileOutputStream = new FileOutputStream(file);
        byte[] content = new byte[1024];
        int amtRead = 0;
        while (amtRead >= 0) {
            amtRead = jarArchiveInputStream.read(content, 0, 1024);
            if (amtRead <= 0) continue;
            fileOutputStream.write(content, 0, amtRead);
        }
        fileOutputStream.close();
        return file;
    }

    static String bestGuessFromNodeList(NodeList nodeList) {
        String projectThing = null;
        String parentThing = null;
        for (int i = 0; i < nodeList.getLength(); ++i) {
            Node thing = nodeList.item(i);
            if (thing.getParentNode().getNodeName().equals("project")) {
                projectThing = thing.getTextContent();
                continue;
            }
            if (!thing.getParentNode().getNodeName().equals("parent")) continue;
            parentThing = thing.getTextContent();
        }
        if (projectThing != null) {
            return projectThing;
        }
        return parentThing;
    }
}

