/*
 * Decompiled with CFR 0.152.
 */
package io.confluent.licenses;

import com.google.common.collect.ImmutableMap;
import com.google.common.collect.ImmutableSet;
import java.io.PrintStream;
import java.util.Map;
import java.util.Set;

public class LicenseEntry {
    private String _url = null;
    private String _name = null;
    private String distribution = null;
    private String comments = null;
    public static String APACHE_LICENSE = "Apache 2.0";
    public static final Map<String, String> licenseUrlToNameMap = ImmutableMap.of((Object)"http://www.apache.org/licenses/LICENSE-2.0.txt", (Object)APACHE_LICENSE, (Object)"http://www.apache.org/licenses/LICENSE-2.0", (Object)APACHE_LICENSE, (Object)"http://www.opensource.org/licenses/mit-license.php", (Object)"The MIT License");
    public static final Set<String> apacheLicenseNames = ImmutableSet.of((Object)"Apache License", (Object)"Apache-2.0", (Object)"Apache License 2.0", (Object)"Apache License, Version 2.0", (Object)"The Apache Software License, Version 2.0", (Object)"Apache 2.0", (Object[])new String[]{"Apache 2", "Apache, Version 2.0"});
    public static final Map<String, String> licenseNameToUrlMap = ImmutableMap.of((Object)APACHE_LICENSE, (Object)"http://www.apache.org/licenses/LICENSE-2.0.txt", (Object)"MIT", (Object)"http://www.opensource.org/licenses/mit-license.php", (Object)"BSD-3-Clause", (Object)"https://opensource.org/licenses/BSD-3-Clause", (Object)"ISC", (Object)"https://opensource.org/licenses/ISC", (Object)"BSD-2-Clause", (Object)"https://opensource.org/licenses/BSD-2-Clause");

    public static String standardizeLicenseName(String name) {
        if (apacheLicenseNames.contains(name)) {
            return APACHE_LICENSE;
        }
        return name;
    }

    public String getUrl() {
        return this._url;
    }

    public void setUrl(String url) {
        this._url = url;
    }

    public String getName() {
        return this._name;
    }

    public void setName(String name) {
        this._name = name;
    }

    public String getDistribution() {
        return this.distribution;
    }

    public void setDistribution(String distribution) {
        this.distribution = distribution;
    }

    public String getComments() {
        return this.comments;
    }

    public void setComments(String comments) {
        this.comments = comments;
    }

    public void printEntry(PrintStream printStream) {
        String name = this.getName();
        String url = this.getUrl();
        if (url == null && name == null) {
            return;
        }
        if (url == null) {
            printStream.printf("%s<br>", name);
        } else {
            printStream.printf("<A HREF=\"%s\">%s</A><br>", url, name);
        }
    }

    public String toString() {
        return "LicenseEntry{url='" + (this._url == null ? "NULL" : this._url) + '\'' + ", name='" + (this._name == null ? "NULL" : this._name) + '\'' + ", distribution='" + this.distribution + '\'' + ", comments='" + this.comments + '\'' + '}';
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        LicenseEntry that = (LicenseEntry)o;
        if (this._url != null ? !this._url.equals(that._url) : that._url != null) {
            return false;
        }
        if (this._name != null ? !this._name.equals(that._name) : that._name != null) {
            return false;
        }
        if (this.distribution != null ? !this.distribution.equals(that.distribution) : that.distribution != null) {
            return false;
        }
        return this.comments != null ? this.comments.equals(that.comments) : that.comments == null;
    }

    public int hashCode() {
        int result = this._url != null ? this._url.hashCode() : 0;
        result = 31 * result + (this._name != null ? this._name.hashCode() : 0);
        result = 31 * result + (this.distribution != null ? this.distribution.hashCode() : 0);
        result = 31 * result + (this.comments != null ? this.comments.hashCode() : 0);
        return result;
    }
}

