/*
 * Decompiled with CFR 0.152.
 */
package io.confluent.licenses;

import com.google.common.collect.Lists;
import com.google.common.collect.Ordering;
import io.confluent.licenses.LicenseTableRow;
import java.io.File;
import java.io.PrintStream;
import java.util.List;

public class LicenseTable {
    List<LicenseTableRow> licenses = Lists.newArrayList();
    String _title = null;

    public LicenseTable(String title) {
        this._title = title;
    }

    public boolean addLicense(LicenseTableRow licenseTableRow) {
        return this.licenses.add(licenseTableRow);
    }

    public void printTable(PrintStream printStream, File licenseOutDir, File licenseFile) throws Exception {
        printStream.print("<HTML><HEAD><style>\ntable {\n    border-collapse: collapse;\n    width: 100%;\n    font-family: sans-serif;\n}\nh1 {\n    font-family: sans-serif;\n}\n\nth, td {\n    text-align: left;\n    padding: 8px;\n}\nthead td {\n    background-color: #333;\n    color: #fff;\n    font-weight: bold;\n}\n\ntr:nth-child(even){background-color: #f2f2f2}\n\nth {\n    background-color: #000000;\n    color: white;\n}\n</style></HEAD><BODY>\n");
        printStream.printf("<H1>%s</H1><br>\n", this._title);
        printStream.print("<TABLE border=\"1\">\n");
        LicenseTableRow.printHeader(printStream);
        printStream.print("<TBODY>\n");
        for (LicenseTableRow license : Ordering.natural().sortedCopy(this.licenses)) {
            license.printRow(printStream, licenseOutDir, licenseFile);
        }
        printStream.print("</TBODY>\n");
        printStream.print("</TABLE>\n");
        printStream.printf("</BODY><HTML>\n", new Object[0]);
    }
}

