/*
 * Decompiled with CFR 0.152.
 */
package io.confluent.monitoring.clients.interceptor;

import io.confluent.shaded.com.google.common.base.MoreObjects;
import io.confluent.shaded.monitoring.record.Monitoring;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class MonitoringMetrics {
    private static final Logger log = LoggerFactory.getLogger(MonitoringMetrics.class);
    private long messageCount = 0L;
    private long byteCount = 0L;
    private long aggregateCrc = 0L;
    private long totalLatency = 0L;
    private long minLatency = Long.MAX_VALUE;
    private long maxLatency = 0L;
    private long minMessageSize = Long.MAX_VALUE;
    private long maxMessageSize = 0L;

    public void recordMessageEvent(int size, long checksum, long latency) {
        ++this.messageCount;
        this.aggregateCrc ^= checksum;
        if (latency >= 0L) {
            this.totalLatency += latency;
            this.minLatency = Math.min(latency, this.minLatency);
            this.maxLatency = Math.max(latency, this.maxLatency);
        } else {
            log.warn("Negative message latency={} ms", (Object)latency);
        }
        if (size > 0) {
            this.byteCount += (long)size;
            this.minMessageSize = Math.min((long)size, this.minMessageSize);
            this.maxMessageSize = Math.max((long)size, this.maxMessageSize);
        } else {
            log.warn("Nonpositive message size={}", (Object)size);
        }
    }

    public void recordMessageEvent(int size, long checksum) {
        this.recordMessageEvent(size, checksum, 0L);
    }

    public void reset() {
        this.messageCount = 0L;
        this.byteCount = 0L;
        this.aggregateCrc = 0L;
        this.totalLatency = 0L;
        this.minLatency = Long.MAX_VALUE;
        this.maxLatency = 0L;
        this.minMessageSize = Long.MAX_VALUE;
        this.maxMessageSize = 0L;
    }

    public long averageLatencyMs() {
        if (this.messageCount == 0L) {
            return 0L;
        }
        return this.totalLatency / this.messageCount;
    }

    public void fillMonitoringMessage(Monitoring.MonitoringMessage.Builder monitoringMessage) {
        monitoringMessage.setAggregateCrc((int)this.aggregateCrc);
        monitoringMessage.setAggregateBytes(this.byteCount);
        monitoringMessage.setCount(this.messageCount);
        monitoringMessage.setTotalLatency(this.totalLatency);
        monitoringMessage.setMinLatency(this.totalLatency == 0L ? 0L : this.minLatency);
        monitoringMessage.setMaxLatency(this.maxLatency);
    }

    public String toString() {
        return MoreObjects.toStringHelper(this).add("messageCount", this.messageCount).add("byteCount", this.byteCount).add("aggregateCrc", this.aggregateCrc).add("totalLatency", this.totalLatency).add("minLatency", this.minLatency).add("maxLatency", this.maxLatency).add("minMessageSize", this.minMessageSize).add("maxMessageSize", this.maxMessageSize).toString();
    }
}

