/*
 * Decompiled with CFR 0.152.
 */
package io.confluent.security.rbac;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import io.confluent.security.authorizer.ResourcePattern;
import io.confluent.security.authorizer.ResourcePatternFilter;
import io.confluent.security.authorizer.Scope;
import io.confluent.security.rbac.RoleBinding;
import java.util.HashSet;
import java.util.Objects;
import org.apache.kafka.common.security.auth.ConfluentPrincipal;
import org.apache.kafka.common.security.auth.KafkaPrincipal;

public class RoleBindingFilter {
    private final KafkaPrincipal principal;
    private final ResourcePatternFilter resourceFilter;
    private final String role;
    private final Scope scope;

    @JsonCreator
    public RoleBindingFilter(@JsonProperty(value="principal") KafkaPrincipal principal, @JsonProperty(value="role") String role, @JsonProperty(value="scope") Scope scope, @JsonProperty(value="resourceFilter") ResourcePatternFilter resourceFilter) {
        this.principal = principal instanceof ConfluentPrincipal ? new KafkaPrincipal(principal.getPrincipalType(), principal.getName()) : principal;
        this.role = role;
        this.scope = scope;
        this.resourceFilter = resourceFilter;
    }

    @JsonProperty
    public KafkaPrincipal principal() {
        return this.principal;
    }

    @JsonProperty
    public String role() {
        return this.role;
    }

    @JsonProperty
    public Scope scope() {
        return this.scope;
    }

    @JsonProperty
    public ResourcePatternFilter resourceFilter() {
        return this.resourceFilter;
    }

    public RoleBinding matchingBinding(RoleBinding roleBinding, boolean matchResource) {
        if (this.principal != null && !this.principal.equals((Object)roleBinding.principal())) {
            return null;
        }
        if (this.role != null && !this.role.equals(roleBinding.role())) {
            return null;
        }
        if (this.scope != null && !this.scope.containsScope(roleBinding.scope())) {
            return null;
        }
        if (this.resourceFilter == null || !matchResource) {
            return roleBinding;
        }
        HashSet<ResourcePattern> roleResources = new HashSet<ResourcePattern>(roleBinding.resources());
        roleResources.removeIf(resource -> !this.resourceFilter.matches(resource));
        if (roleResources.isEmpty()) {
            return null;
        }
        if (roleResources.size() == roleBinding.resources().size()) {
            return roleBinding;
        }
        return new RoleBinding(roleBinding.principal(), roleBinding.role(), roleBinding.scope(), roleResources);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof RoleBindingFilter)) {
            return false;
        }
        RoleBindingFilter that = (RoleBindingFilter)o;
        return Objects.equals(this.principal, that.principal) && Objects.equals(this.role, that.role) && Objects.equals(this.scope, that.scope) && Objects.equals(this.resourceFilter, that.resourceFilter);
    }

    public int hashCode() {
        return Objects.hash(this.principal, this.role, this.scope, this.resourceFilter);
    }

    public String toString() {
        return "RoleBindingFilter(principal=" + this.principal + ", role='" + this.role + '\'' + ", scope='" + this.scope + '\'' + ", resourceFilter=" + this.resourceFilter + ')';
    }
}

