/*
 * Decompiled with CFR 0.152.
 */
package io.confluent.security.auth.client.rest;

import java.util.ArrayList;
import java.util.List;
import java.util.Random;

public class UrlSelector {
    private int index;
    private final List<String> urls;

    public UrlSelector(List<String> urls) {
        if (urls == null || urls.isEmpty()) {
            throw new IllegalArgumentException("Expected at least one metadata server URL to be passed in constructor");
        }
        this.urls = new ArrayList<String>(urls);
        this.index = new Random().nextInt(urls.size());
    }

    public String current() {
        return this.urls.get(this.index);
    }

    public void fail() {
        this.index = (this.index + 1) % this.urls.size();
    }

    public int size() {
        return this.urls.size();
    }

    public int index() {
        return this.index;
    }

    public String toString() {
        return this.urls.toString();
    }
}

