/*
 * Decompiled with CFR 0.152.
 */
package io.confluent.security.auth.common;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.nio.charset.Charset;
import java.security.Key;
import java.security.PublicKey;
import org.bouncycastle.asn1.x509.SubjectPublicKeyInfo;
import org.bouncycastle.openssl.PEMParser;
import org.bouncycastle.openssl.jcajce.JcaPEMKeyConverter;
import org.jose4j.jwt.consumer.JwtConsumer;
import org.jose4j.jwt.consumer.JwtConsumerBuilder;

public class TokenUtils {
    private static final Charset US_ASCII = Charset.forName("US-ASCII");
    private static final String JWT_ISSUER = "Confluent";

    public static PublicKey loadPublicKey(InputStream inputStream) throws IOException {
        try (InputStreamReader reader = new InputStreamReader(inputStream, US_ASCII);){
            PEMParser pemParser = new PEMParser((Reader)new BufferedReader(reader));
            SubjectPublicKeyInfo keyInfo = SubjectPublicKeyInfo.getInstance((Object)pemParser.readObject());
            PublicKey publicKey = new JcaPEMKeyConverter().getPublicKey(keyInfo);
            return publicKey;
        }
    }

    public static JwtConsumer createJwtConsumer(PublicKey publicKey) {
        return new JwtConsumerBuilder().setExpectedIssuer(JWT_ISSUER).setVerificationKey((Key)publicKey).setRequireExpirationTime().setRequireIssuedAt().setRequireJwtId().setRequireSubject().build();
    }
}

