/*
 * Decompiled with CFR 0.152.
 */
package io.confluent.security.auth.client.provider;

import io.confluent.security.auth.client.RestClientConfig;
import io.confluent.security.auth.client.provider.BasicAuthCredentialProvider;
import io.confluent.security.auth.client.provider.BuiltInAuthProviders;
import io.confluent.security.auth.client.provider.HttpCredentialProvider;
import java.nio.charset.StandardCharsets;
import java.util.Base64;
import java.util.Map;

public class HttpBasicCredentialProvider
implements HttpCredentialProvider {
    private BasicAuthCredentialProvider basicAuthCredentialProvider;
    private String userInfo;

    public HttpBasicCredentialProvider() {
    }

    public HttpBasicCredentialProvider(String userInfo) {
        this.userInfo = HttpBasicCredentialProvider.encodeUserInfo(userInfo);
    }

    public static String encodeUserInfo(String userInfo) {
        return Base64.getEncoder().encodeToString(userInfo.getBytes(StandardCharsets.UTF_8));
    }

    public void configure(Map<String, ?> configs) {
        if (this.userInfo != null || this.basicAuthCredentialProvider != null) {
            throw new IllegalStateException("HttpBasicCredentialProvider already initialized");
        }
        RestClientConfig rbacClientConfig = new RestClientConfig(configs);
        String basicAuthProvider = rbacClientConfig.getString("confluent.metadata.basic.auth.credentials.provider");
        this.basicAuthCredentialProvider = BuiltInAuthProviders.loadBasicAuthCredentialProvider(basicAuthProvider);
        this.basicAuthCredentialProvider.configure(configs);
    }

    @Override
    public String getScheme() {
        return "Basic";
    }

    @Override
    public String getCredentials() {
        if (this.basicAuthCredentialProvider != null) {
            return HttpBasicCredentialProvider.encodeUserInfo(this.basicAuthCredentialProvider.getUserInfo());
        }
        return this.userInfo;
    }
}

